// This file contains the DCC and LED definitions.
//
// It was automatically generated by the program ProgGenerator Ver. 3.5.0C1      by Hardi
// File creation: 02/04/26 12:40:30
// (Attention: The display in the Arduino IDE is not updated if Options/External Editor is disabled)

#ifndef __LEDS_AUTOPROG_H__
#define __LEDS_AUTOPROG_H__

#ifndef CONFIG_ONLY
#ifndef ARDUINO_RASPBERRY_PI_PICO
#ifndef FASTLED_ESP32_I2S
#define FASTLED_INTERNAL       // Disable version number message in FastLED library (looks like an error)
#endif
#include <FastLED.h>           // The FastLED library must be installed in addition if you got the error message "..fatal error: FastLED.h: No such file or directory"
                               // Arduino IDE: Sketch / Include library / Manage libraries                    Deutsche IDE: Sketch / Bibliothek einbinden / Bibliothek verwalten
                               //              Type "FastLED" in the "Filter your search..." field                          "FastLED" in das "Grenzen Sie ihre Suche ein" Feld eingeben
                               //              Select the entry and click "Install"                                         Gefundenen Eintrag auswaehlen und "Install" anklicken
#else
#include <PicoFastLED.h>       // Juergens minimum version or FastLED for Raspberry Pico
#endif
#endif // CONFIG_ONLY

#include <MobaLedLib.h>

#define START_MSG "LEDs_AutoProg Ver 3: PICO 3.5.0C1 02.04.26 12:40"

#define TWO_BUTTONS_PER_ADDRESS 1      // Two buttons (Red/Green) are used (DCC/LNet/CAN)
#ifdef NUM_LEDS
  #warning "'NUM_LEDS' definition in the main program is replaced by the included 'LEDs_AutoProg.h' with 20"
  #undef NUM_LEDS
#endif

#define NUM_LEDS 20                    // Number of LEDs (Maximal 256 RGB LEDs could be used)

#define LEDS_PER_CHANNEL ",19,0,0,0,0,0,1"

#define USE_PROTOCOL_DCC

#define RECEIVE_LED_COLOR_PER_RS232

#define GEN_BUTTON_RELEASE
#define GEN_BUTTON_RELEASE_COM GEN_OFF
// Input channel defines for local inputs and expert users


#ifndef CONFIG_ONLY
//*** Analog switches ***

#include "AnalogScannerPico.h"   
AnalogScannerPico scanner;        // Creates an instance of the analog pin scanner.

#include <Analog_Buttons10.h>
Analog_Buttons10_C AButtons1(26);


#endif //CONFIG_ONLY
#define SwitchA1                0                                        // Z21-RM-Rückmelder: Adresse:1 Eingang:1
#define SwitchA2                1                                        // Z21-RM-Rückmelder: Adresse:1 Eingang:2
#define SwitchA3                2                                        // Z21-RM-Rückmelder: Adresse:1 Eingang:3
#define SwitchA4                3                                        // Z21-RM-Rückmelder: Adresse:1 Eingang:4
// Reserve channels: 4 because MobaLedLib_Copy_to_InpStruct always writes multiple of 8 channels
#define START_SWITCHES_A  0                                        // Define the start number for the first analog switch

//*** Output Channels ***
#define START_VARIABLES   16                                       // Define the start number for the variables.
#define MoLLi                   16                                       // Z21-RM-Rückmelder: Adresse:3 Eingang:1
#define Blauw                   17                                       // Z21-RM-Rückmelder: Adresse:3 Eingang:2
#define Kleurenwiel             18                                       // Z21-RM-Rückmelder: Adresse:3 Eingang:3
#define Groen                   19                                       // Z21-RM-Rückmelder: Adresse:3 Eingang:4


#define START_SEND_INPUTS 0                                        // Start address of all switches/variables
#define TOTAL_SEND_INPUTS 20                                       // Number of used switches/variables
#define TOTAL_SWITCHES_A  16                                       // Number of used inputs for analog keyboard
#define TOTAL_SWITCHES_B  0                                        // Number of used inputs for keyboard 1
#define TOTAL_SWITCHES_C  0                                        // Number of used inputs for keyboard 2
#define TOTAL_SWITCHES_D  0                                        // Number of used inputs for main board switches
#define TOTAL_VARIABLES   4                                        // Number of used variables
/*********************/
#define SETUP_FASTLED()                                                      \
/*********************/                                                      \
  CLEDController& controller0 = FastLED.addLeds<NEOPIXEL,  0>(leds+  0, 19); \
  CLEDController& controller6 = FastLED.addLeds<NEOPIXEL, 16>(leds+ 19,  1); \
                                                                             \
  controller0.clearLeds(256);                                                \
  controller6.clearLeds(256);                                                \
  FastLED.setDither(DISABLE_DITHER);       // avoid sending slightly modified brightness values
/*End*/

#define USE_ADDITIONAL_SETUP_PROC                                  // Activate the usage of the Additional_Setup_Proc()

//--------------------------
void Additional_Setup_Proc()
//--------------------------
{
#ifndef CONFIG_ONLY
  int scanOrder[] = {26};
  const int SCAN_COUNT = sizeof(scanOrder) / sizeof(scanOrder[0]);
  scanner.setScanPins(SCAN_COUNT, scanOrder);
#endif

}

/****************************/
#define Additional_Loop_Proc() \
/****************************/ \
{                              \
  uint16_t Button;             \
  Button = AButtons1.Get(); MobaLedLib_Copy_to_InpStruct((uint8_t*)&Button, 2, 0);       \
}


//*******************************************************************
// *** Configuration array which defines the behavior of the LEDs ***
MobaLedLib_Configuration()
  {
  T_FlipFlopReset(MoLLi, SwitchA2, SI_0)                                                                      /* Toggle FlipFlop                                                                                                                                                                             */
  ConstRGB(19, MoLLi, 0, 0, 0, 235, 253, 1)                                                                   /* PICO WS2812B onder de letter O van MoLLi op behuizing (Geel)                                                                                                                                */
  T_FlipFlopReset(Blauw, SwitchA3, SI_0)                                                                      /* Toggle FlipFlop                                                                                                                                                                             */
  ConstRGB(0, Blauw, 0, 0, 0, 0, 0, 127)                                                                      /* Eerste RGB LED (WS2812D-F5) op MB (Blauw)                                                                                                                                                   */
  T_FlipFlopReset(Kleurenwiel, SwitchA1, SI_0)                                                                /* Toggle FlipFlop                                                                                                                                                                             */
  RGB_Ring(1, Kleurenwiel, 30, 80)                                                                            /* Kleurenwiel MobaLedLib Logo                                                                                                                                                                 */
  T_FlipFlopReset(Groen, SwitchA4, SI_0)                                                                      /* Toggle FlipFlop                                                                                                                                                                             */
  ConstRGB(13, Groen, 0, 0, 0, 0, 127, 0)                                                                     /* Retour RGB LED (WS2812D-255) op MB (Groen)                                                                                                                                                  */

  EndCfg // End of the configuration
  };
//*******************************************************************

#ifndef COPYLED_OFF
#define COPYLED_OFF 0
#endif

#ifndef COPYLED_OFF_ONCE
#define COPYLED_OFF_ONCE 1
#endif

//---------------------------------------------
void Set_Start_Values(MobaLedLib_C &MobaLedLib)
//---------------------------------------------
{
}


// if function returns TRUE the calling loop stops
typedef bool(*HandleValue_t) (uint8_t CallbackType, uint8_t ValueId, uint8_t* Value, uint16_t EEPromAddr, uint8_t TargetValueId, uint8_t Options);


#define InCnt_MSK  0x003F  // 6 bits are used for the InCnt, 2 bits for the type ttcc cccc => Max InCnt=63
#define IS_COUNTER (uint8_t)0x80
#define IS_PULSE   (uint8_t)0x40
#define IS_TOGGLE  (uint8_t)0x00
#define COUNTER_ID

typedef struct
    {
    uint8_t TypAndInCnt; // Type bits 7 & 6, InCnt 0..5
    uint8_t Channel;
    } __attribute__ ((packed)) Store_Channel_T;

// Definition of channels and counters that need to store state in EEProm
const PROGMEM Store_Channel_T Store_Values[] =
         { // Mode + InCnt , Channel
           { IS_COUNTER    , COUNTER_ID 1        },      // Toggle FlipFlop
           { IS_COUNTER    , COUNTER_ID 2        },      // Toggle FlipFlop
           { IS_COUNTER    , COUNTER_ID 3        },      // Toggle FlipFlop
           { IS_COUNTER    , COUNTER_ID 4        },      // Toggle FlipFlop
         };

#ifndef CONFIG_ONLY
#endif // CONFIG_ONLY





#endif // __LEDS_AUTOPROG_H__
