// This file contains the DCC and LED definitions.
//
// It was automatically generated by the program ProgGenerator Ver. 3.5.0C1      by Hardi
// File creation: 01/30/26 15:24:10
// (Attention: The display in the Arduino IDE is not updated if Options/External Editor is disabled)

#ifndef __LEDS_AUTOPROG_H__
#define __LEDS_AUTOPROG_H__

#ifndef CONFIG_ONLY
#ifndef ARDUINO_RASPBERRY_PI_PICO
#ifndef FASTLED_ESP32_I2S
#define FASTLED_INTERNAL       // Disable version number message in FastLED library (looks like an error)
#endif
#include <FastLED.h>           // The FastLED library must be installed in addition if you got the error message "..fatal error: FastLED.h: No such file or directory"
                               // Arduino IDE: Sketch / Include library / Manage libraries                    Deutsche IDE: Sketch / Bibliothek einbinden / Bibliothek verwalten
                               //              Type "FastLED" in the "Filter your search..." field                          "FastLED" in das "Grenzen Sie ihre Suche ein" Feld eingeben
                               //              Select the entry and click "Install"                                         Gefundenen Eintrag auswaehlen und "Install" anklicken
#else
#include <PicoFastLED.h>       // Juergens minimum version or FastLED for Raspberry Pico
#endif
#endif // CONFIG_ONLY

#include <MobaLedLib.h>

#define START_MSG "LEDs_AutoProg Ver 3: PICO 3.5.0C1 01.30.26 15:24"

#define TWO_BUTTONS_PER_ADDRESS 1      // Two buttons (Red/Green) are used (DCC/LNet/CAN)
#ifdef NUM_LEDS
  #warning "'NUM_LEDS' definition in the main program is replaced by the included 'LEDs_AutoProg.h' with 20"
  #undef NUM_LEDS
#endif

#define NUM_LEDS 20                    // Number of LEDs (Maximal 256 RGB LEDs could be used)

#define LEDS_PER_CHANNEL ",20"

#define USE_PROTOCOL_DCC

#define RECEIVE_LED_COLOR_PER_RS232

#define GEN_BUTTON_RELEASE
#define GEN_BUTTON_RELEASE_COM GEN_OFF
#define USE_EXT_ADDR
#define USE_RS232_OR_SPI_AS_INPUT      // Use the RS232 or SPI Input to read DCC/SX commands from the second Arduino and from the PC (The SPI is only used if enabled with USE_SPI_COM)
#define ADDR_OFFSET 0

#define ADDR_MSK  0x3FFF  // 14 Bits are used for the Address

#define S_ONOFF   (uint16_t)0
#define B_RED     (uint16_t)(1<<14)
#define B_GREEN   (uint16_t)(2<<14)
#define O_RET_MSG (uint16_t)(3<<14)    // Return messages (Rueckmelder)
#define B_TAST    B_RED


typedef struct
    {
    uint16_t AddrAndTyp; // Addr range: 0..16383. The upper two bytes are used for the type
    uint8_t  InCnt;
    } __attribute__ ((packed)) Ext_Addr_T;

// Definition of external adresses
#ifdef CONFIG_ONLY
const Ext_Addr_T Ext_Addr[] __attribute__ ((section (".MLLAddressConfig"))) =
#else
const PROGMEM Ext_Addr_T Ext_Addr[] =
#endif
         { // Addr & Typ    InCnt
           { 100  + B_RED,     2 },      // Sensor1
           { 101  + B_RED,     2 },      // Servo2
           { 103  + B_RED,     2 },      // Servo3
         };


// Input channel defines for local inputs and expert users
#define INCH_DCC_100_RED        0      // Sensor1
#define INCH_DCC_100_GREEN      1      //     "
#define INCH_DCC_101_RED        2      // Servo2
#define INCH_DCC_101_GREEN      3      //     "
#define INCH_DCC_103_RED        4      // Servo3
#define INCH_DCC_103_GREEN      5      //     "



#define TOTAL_SWITCHES_A  0                                        // Number of used inputs for analog keyboard
#define TOTAL_SWITCHES_B  0                                        // Number of used inputs for keyboard 1
#define TOTAL_SWITCHES_C  0                                        // Number of used inputs for keyboard 2
#define TOTAL_SWITCHES_D  0                                        // Number of used inputs for main board switches
#define TOTAL_VARIABLES   1                                        // Number of used variables
/*********************/
#define SETUP_FASTLED()                                                      \
/*********************/                                                      \
  CLEDController& controller0 = FastLED.addLeds<NEOPIXEL,  0>(leds+  0, 20); \
                                                                             \
  controller0.clearLeds(256);                                                \
  FastLED.setDither(DISABLE_DITHER);       // avoid sending slightly modified brightness values
/*End*/



//*******************************************************************
// *** Configuration array which defines the behavior of the LEDs ***
MobaLedLib_Configuration()
  {
  RGB_Heartbeat(0)                                                                                            /* LED auf dem Mainboard                                                                                                                                                                       */
  Servo2(1, 0, C1, 10, 210, 10 Sek)                                                                           /* Sensor1                                                                                                                                                                                     */
  Servo2(1, 2, C2, 10, 210, 10 Sek)                                                                           /* Servo2                                                                                                                                                                                      */
  Servo2(1, 4, C3, 10, 210, 10 Sek)                                                                           /* Servo3                                                                                                                                                                                      */

  EndCfg // End of the configuration
  };
//*******************************************************************

#ifndef COPYLED_OFF
#define COPYLED_OFF 0
#endif

#ifndef COPYLED_OFF_ONCE
#define COPYLED_OFF_ONCE 1
#endif

//---------------------------------------------
void Set_Start_Values(MobaLedLib_C &MobaLedLib)
//---------------------------------------------
{
}


// No macros used which are stored to the EEPROM => Disable the ENABLE_STORE_STATUS flag in case it was set in the excel sheet
#ifdef ENABLE_STORE_STATUS
  #undef ENABLE_STORE_STATUS
#endif

#ifndef CONFIG_ONLY
#endif // CONFIG_ONLY





#endif // __LEDS_AUTOPROG_H__
