@ECHO OFF
REM This file was generated by 'ProgGenerator'  
CHCP 65001 >NUL

if not exist MyPrivateBuildScript.cmd (
  REM embedded Fast Build and Upload
  call :build "C:\Program Files (x86)\Arduino\" "LEDs_AutoProg.ino" COM8 "arduino:avr:nano:cpu=atmega328" 115200  "C:\Users\harol\Documents\Arduino/libraries" atmega328p %*
) else (
  REM user defined Build and Upload
  call MyPrivateBuildScript.cmd "C:\Program Files (x86)\Arduino\" "LEDs_AutoProg.ino" COM8 "arduino:avr:nano:cpu=atmega328" 115200  "C:\Users\harol\Documents\Arduino/libraries" atmega328p %*
)
IF ERRORLEVEL 1 ECHO Start_Arduino_Result: %ERRORLEVEL% > "Start_Arduino_Result.txt"
goto :eof
:build
@ECHO OFF
REM Fast Build command from Juergen
REM ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
REM
REM Compile and flash time 10 sec instead of 23 sec ! on Hardis laptop
REM
REM Speed up by
REM - not using the Arduino Core
REM - not checking the flash at the end (saves 3 sec)
REM
REM This file could be modified by the user to support special compiler switches
REM It is called if the switch the "Schnells Build und Upload verwenden:" in the 'Config' sheet is enabled
REM
REM Parameter:               Example
REM  1: Arduino EXE Path:    "C:\Program Files (x86)\Arduino\"
REM  2: Ino Name:            "LEDs_AutoProg.ino"
REM  3: Com port:            "\\.\COM3"
REM  4: Build options:       "arduino:avr:nano:cpu=atmega328"
REM  5: Baudrate:            "57600" or "115200"
REM  6: Arduino Library path "%USERPROFILE%\Documents\Arduino\libraries"
REM  7: CPU type:            "atmega328p, atmega4809
REM  8: options:             "noflash|norebuild"
REM
REM The program uses the captured and adapted command line from the Arduino IDE
REM

SET aHome=%~1
SET fqbn=%~4
SET lib=%~6


SET aTemp=%USERPROFILE%\AppData\Local\Temp\pyMobaLedLib_build\ATMega
SET aCache=%USERPROFILE%\AppData\Local\Temp\MobaLedLib_cache\ATMega
if not exist "%aTemp%"  md "%aTemp%"
if not exist "%aCache%" md "%aCache%"

if exist "%aTemp%\buildFailed.txt" (
   echo Last build failed ;-( - rebuild everything
   rd "%aTemp%" /s/q
   rd "%aCache%" /s/q
   md "%aTemp%"
   md "%aCache%"
)

xcopy D:\Development\github\pyMobaLedLib\python\LEDs_AutoProg\boards.local.txt "C:\Users\harol\AppData\Local\Arduino15\packages\arduino\hardware\avr\1.8.6\" /d /y >nul

REM *** Call the arduino builder ***
"%aHome%\arduino-builder" -compile -logger=human ^
     -hardware "%aHome%\hardware" ^
     -hardware "C:\Users\harol\AppData\Local\Arduino15\packages" ^
     -tools "%aHome%\tools-builder" ^
     -tools "%aHome%\hardware\tools\avr" ^
     -built-in-libraries "%aHome%\libraries" -libraries "%LIB%" ^
     -fqbn=%fqbn% -build-path "%aTemp%" ^
     -warnings=default ^
     -build-cache "%aCache%" ^
     -prefs=build.warn_data_percentage=75 ^
     -prefs=runtime.tools.avrdude.path="%aHome%\hardware\tools\avr" ^
     -prefs=runtime.tools.avr-gcc.path="%aHome%\hardware\tools\avr"  ^
     %2
if errorlevel 1 (
    echo %date% > "%aTemp%\buildFailed.txt"
    exit /b 1
)

set subType=%7
set mainType=%subType:~0,9%

if "%8"=="noflash" goto :EOF
   REM *** Flash program ***
   REM -v = Verbose output. -v -v for more.
   REM -V = Do not verify.                      => Saves 3 sec
   REM -D = Disable auto erase for flash memory
   set extraArgs=
   if "%7"=="atmega4809" (
      echo Forcing reset using 1200bps open/close on port %3
      mode %3 1200,n,8,1
      set extraArgs=-cjtag2updi -e -Ufuse2:w:0x01:m -Ufuse5:w:0xC9:m -Ufuse8:w:0x00:m
      goto flash
   )

if "%mainType%"=="atmega328" (
   set extraArgs=-carduino
   goto flash
)
:flash
"%aHome%\hardware\tools\avr/bin/avrdude" -C"%aHome%\hardware\tools\avr/etc/avrdude.conf" ^
   -V -p%7 -P\\.\%3 -b%~5 -D -Uflash:w:"%aTemp%/%~2.hex":i %extraArgs%
