#line 90 "Lib_Config.h"
const uint8_t Buttons[] = { 7, 8, 9 };
#line 1204 "MobaLedLib.h"
inline bool Inp_Changed_or_InitOff(uint8_t Inp)

{
  return Inp == 0b00000001 || Inp == 0b00000010 || Inp == 0b00000110;
}
#line 1217 "MobaLedLib.h"
inline uint8_t Invert_Inp(uint8_t Inp)

{
  return Inp ^ 0b00000011;
}


inline bool Inp_Is_On(uint8_t Inp)

{
  return Inp == 0b00000011 || Inp == 0b00000001;
}


inline bool Inp_Is_TurnedOff_or_InitOff(uint8_t Inp)

{
  return Inp == 0b00000010 || Inp == 0b00000110 ;
}


inline bool Inp_Changed(uint8_t Inp)

{
  return Inp == 0b00000001 || Inp == 0b00000010;
}
#line 1268 "MobaLedLib.h"
extern uint8_t    Darkness;
extern DayState_E DayState;

extern uint8_t    TestMode;
#line 1294 "MobaLedLib.h"
   typedef void(*Callback_t) (uint8_t CallbackType, uint8_t ValueId, uint8_t OldValue, uint8_t* NewValue);


   typedef uint8_t(*ExtProc_t) (uint8_t Type, const uint8_t* progmemAddress, bool process);



class MobaLedLib_C

{
public:



                    MobaLedLib_C(struct CRGB* _leds, uint16_t Num_Leds, const uint8_t Config[], uint8_t RAM[], uint16_t RamSize, Callback_t Function, ExtProc_t Processor);
#line 1320 "MobaLedLib.h"
 void               Assigne_GlobalVar(ControlVar_t *GlobalVar, uint8_t GlobalVar_Cnt);

 void               Update();
 void               Set_Input(uint8_t channel, uint8_t On);
 int8_t             Get_Input(uint8_t channel);
 void               Copy_Bits_to_InpStructArray(uint8_t *Src, uint8_t ByteCnt, uint8_t InpStructArrayNr);
 void               Print_Config();

public:
 uint8_t            Trigger20fps;
 CRGB*              leds;
 uint16_t           Num_Leds;

private:
 const uint8_t     *cp;
 const uint8_t     *Config;
 bool               Initialize;
 uint8_t           *RAM;
 uint8_t            Last_20;
 uint8_t            TriggerCnt;
 uint8_t           *rp;
 uint32_t           t;

 uint16_t           t4w;
 uint8_t            t10;

 TV_Dat_T           TV_Dat[2];
 uint8_t            InpStructArray[64];
 HSV_T             *HSV_p;
 ControlVar_t      *ActualVar_p;

 ControlVar_t      *GlobalVar;

 ControlVar_t       TempVar;
 uint8_t            GlobalVar_Cnt;
 Sound_Dat_t       *Sound_Dat;

 Callback_t         CallbackFunc;
 uint8_t            ProcCounterId;


 ExtProc_t          CommandProcessorFunc;
#line 1368 "MobaLedLib.h"
 uint8_t            Rand_On_DefNeon;
 uint8_t            RandOff_DefNeon;
 uint8_t            Min_DefNeon;




 uint8_t           *Get_LEDPtr(uint8_t &cnt);
 uint8_t            Is_Room_On(CRGB *lp, uint8_t RawNr);
 void               Update_TV_or_Chimney(uint8_t TVNr, CRGB *lp, uint8_t Room_Typ);
 uint8_t            Get_RawNr(uint8_t Room_Typ);
 void               Update_Gas_Light( uint8_t Room_Typ, CRGB *lp);
 void               Update_Neon_Light(uint8_t Room_Typ, CRGB *lp);
 void               Update_Candle(uint8_t Room_Typ, CRGB *lp);
 void               Proc_Set_CandleTab();
 void               TurnOnRoom(CRGB* lp, uint8_t Room_Typ);
 void               TurnOffRoom(CRGB* lp, uint8_t RawNr, uint8_t Room_Typ);
 void               Set_Default_TV_Dat_p();
 void               Update_TV_Data();
 void               Random_Const_Light(CRGB *lp, uint8_t TVNr);
 void               Enable_Light_or_TV(CRGB *lp, uint8_t TVNr);
 void               Enable_Chimney(CRGB *lp);
 void               Enable_Light_or_Chimney(CRGB *lp);
 void               Enable_Light_TV_or_Chimney(CRGB *lp, uint8_t TVNr);
 void               Set_Timer4Random(uint16_t Timer, TimerData16_T *dp, uint8_t P_MinTime);
 void               Set_Dest_RandMux(uint8_t Act, uint8_t Mode);
 void               Inp_Processed();
 void               CalcSwitchVal(Schedule_T *dp);
 uint8_t            Is_Pattern(uint8_t Type);
 void               Print_Comment(uint8_t Type);
 void               Int_Update(uint32_t Time);
 void               Inc_cp(uint8_t Type);
 uint8_t            Find_Next_Priv_InpChannel(uint8_t Channel, int8_t Direction);



 void               Setup_Test_Buttons();
 void               Set_one_Test_Outp(uint8_t Nr, CRGB* &p);
 void               Set_Test_Outp(uint8_t &Ch);
 void               Speed_Test();
 void               Proc_Key_Test(uint8_t key);
 void               Proc_Test_Buttons();


 void               Proc_Const();
 void               Proc_AnalogPattern(uint8_t TimeCnt, bool AnalogMode);
 void               Proc_House();
 void               Proc_Fire();



 void               Proc_Set_TV_Tab();
 void               Proc_Set_Def_Neon();
 void               Proc_Logic();
 void               Proc_New_HSV_Group();
 void               Proc_New_Local_Var();
 void               Proc_Use_GlobalVar();

 void               Proc_InCh_to_X_Var();
 void               Proc_Bin_InCh_to_TmpVar();




 void               Proc_Random();
 void               Proc_RandMux();
 void               Proc_Welding(uint8_t withbreaks);
 void               Proc_CopyLED();
 void               Proc_Schedule();
 void               Proc_Counter();

 void               IncCP_House();
 void               IncCP_Const()         { cp += 5 + ADD_WORD_OFFSET; }
 void               IncCP_Fire()          { cp += 4 + ADD_WORD_OFFSET; }
#line 1450 "MobaLedLib.h"
   void             IncCP_Set_CandleTab()  { cp += sizeof(Candle_Dat_T); }

 void               IncCP_Set_TV_Tab();
 void               IncCP_Set_Def_Neon();
 void               IncCP_Pattern(uint8_t TimeCnt);
 void               IncCP_Logic();
 void               IncCP_New_HSV_Group() { }
 void               IncCP_New_Local_Var() { }
 void               IncCP_Use_GlobalVar() { cp++; }
 void               IncCP_InCh_to_X_Var() { cp+=2; }
 void               IncCP_Random()        { cp += EP_RANDOM_INCREMENT;   }
 void               IncCP_RandMux()       { cp += EP_RANDMUX_INCREMENT;  }
 void               IncCP_Welding()       { cp += EP_WELDING_INCREMENT;  }
 void               IncCP_CopyLED()       { cp += EP_COPYLED_INCREMENT;  }
 void               IncCP_Schedule()      { cp += EP_SCHEDULE_INCREMENT; }
 void               IncCP_Counter();

 uint8_t            InpChannel_used(uint8_t Channel);
 bool               Inp_is_Used_in_Logic(uint8_t Channel);


 void               Do_Callback(uint8_t CallbackType, uint8_t ValueId, uint8_t OldValue, uint8_t *NewValue);
#line 1479 "MobaLedLib.h"
   const Candle_Dat_T *Candle_DatP;



   const uint8_t     *TV_Dat_p[2];


friend class MLLExtension;
};
#line 57 "D:\data\doc\GitHub\pyMobaLedLib\python\LEDs_AutoProg\LEDs_AutoProg.h"
typedef struct
    {
    uint16_t AddrAndTyp;
    uint8_t  InCnt;
    } __attribute__ ((packed)) Ext_Addr_T;





const PROGMEM Ext_Addr_T Ext_Addr[] =

         {
           { 100  + (uint16_t)0,   1 },
           { 981  + (uint16_t)0,   1 },
           { 982  + (uint16_t)0,   1 },
           { 983  + (uint16_t)0,   1 },
           { 984  + (uint16_t)0,   1 },
           { 977  + (uint16_t)0,   1 },
           { 978  + (uint16_t)0,   1 },
           { 976  + (uint16_t)0,   1 },
           { 103  + (uint16_t)0,   1 },
           { 101  + (uint16_t)(1<<14),     4 },
           { 27   + (uint16_t)0,   1 },
           { 28   + (uint16_t)0,   1 },
           { 805  + (uint16_t)0,   1 },
           { 975  + (uint16_t)0,   1 },
           { 30   + (uint16_t)0,   1 },
           { 979  + (uint16_t)0,   1 },
           { 980  + (uint16_t)0,   1 },
           { 201  + (uint16_t)0,   1 },
         };
#line 200 "D:\data\doc\GitHub\pyMobaLedLib\python\LEDs_AutoProg\LEDs_AutoProg.h"
  typedef struct
      {
      uint8_t  Var_Nr;
      uint8_t  LED_Nr;
      uint8_t  Offset_and_Typ;
      uint8_t  Val;
      } __attribute__ ((packed)) LED2Var_Tab_T;




  const PROGMEM LED2Var_Tab_T LED2Var_Tab[] =

      {

        { 59,                 0,     (0   << 3) | 3,    100 }
      };
#line 223 "D:\data\doc\GitHub\pyMobaLedLib\python\LEDs_AutoProg\LEDs_AutoProg.h"
const PROGMEM unsigned char Config[] =
  {

  1, (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8)+0,(1 + (0<<2)),((59) < 64*4 ? (59) : (256<<6)),0, 127, 1, (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8)+0,(1 + (1<<2)),((59) < 64*4 ? (59) : (256<<6)),0, 127, 1, (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8)+0,(1 + (2<<2)),((59) < 64*4 ? (59) : (256<<6)),0, 127,
#line 234 "D:\data\doc\GitHub\pyMobaLedLib\python\LEDs_AutoProg\LEDs_AutoProg.h"
  170+1 + 24 - 25+1 + 26 - 27+1 + 28 - 29, 74,  (((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8)+1 + 30 - 31+1 + 32 - 33+1 + 34 - 35+1 + 36 - 37+1 + 38 - 39+1 + 40 - 41+1 + 42 - 43,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,150,150,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8)+1 + 44 - 45+1 + 46 - 47+1 + 48 - 49+1 + 50 - 51+1 + 52 - 53+1 + 54 - 55+1 + 56 - 57,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,120,0,6|0x20,          (((uint32_t)(1 *1000L))&0xFF), (((uint32_t)(1 *1000L))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 58 - 59+1 + 60 - 61+1 + 62 - 63, 74,  (((uint32_t)(248))&0xFF), (((uint32_t)(248))>>8)+1 + 64 - 65+1 + 66 - 67+1 + 68 - 69+1 + 70 - 71+1 + 72 - 73+1 + 74 - 75+1 + 76 - 77,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,150,150,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(248))&0xFF), (((uint32_t)(248))>>8)+1 + 78 - 79+1 + 80 - 81+1 + 82 - 83+1 + 84 - 85+1 + 86 - 87+1 + 88 - 89+1 + 90 - 91,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,120,0,6|0x20,          (((uint32_t)(1 *1000L))&0xFF), (((uint32_t)(1 *1000L))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  181, 255, 0x00, 31, 156, 40, 65, 0, 85, 70, 210, 60, 150,
  181, 255, 0x01, 31, 156, 40, 65, 0, 85, 70, 210, 60, 150,
  170+1 + 92 - 93+1 + 94 - 95+1 + 96 - 97, 74,  (((uint32_t)(2))&0xFF), (((uint32_t)(2))>>8)+1 + 98 - 99+1 + 100 - 101+1 + 102 - 103+1 + 104 - 105+1 + 106 - 107+1 + 108 - 109+1 + 110 - 111,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(2))&0xFF), (((uint32_t)(2))>>8)+1 + 112 - 113+1 + 114 - 115+1 + 116 - 117+1 + 118 - 119+1 + 120 - 121+1 + 122 - 123+1 + 124 - 125,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  74,  (((uint32_t)(3))&0xFF), (((uint32_t)(3))>>8)+1 + 126 - 127+1 + 128 - 129+1 + 130 - 131+1 + 132 - 133+1 + 134 - 135+1 + 136 - 137+1 + 138 - 139+1 + 140 - 141+1 + 142 - 143+1 + 144 - 145,(28)&0xFF,((0) < 64*4 ? (0) : (256<<6)),255,  3,0,255,0,0|0x08,(((uint32_t)(8 *1000L))&0xFF), (((uint32_t)(8 *1000L))>>8),(((uint32_t)(18))&0xFF), (((uint32_t)(18))>>8), 0,35,35,0,0,210,42,0,42,70,0,0,42,42,0,0,77,0,
  143,   1,       (((uint32_t)(4))&0xFF), (((uint32_t)(4))>>8), 255, (((uint32_t)(2))&0xFF), (((uint32_t)(2))>>8),
  143,   1,       (((uint32_t)(5))&0xFF), (((uint32_t)(5))>>8), 255, (((uint32_t)(2))&0xFF), (((uint32_t)(2))>>8),
  1, (((uint32_t)(6))&0xFF), (((uint32_t)(6))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 40,
  13,  (((uint32_t)(7))&0xFF), (((uint32_t)(7))>>8)+1 + 146 - 147+1 + 148 - 149+1 + 150 - 151+1 + 152 - 153+1 + 154 - 155,           (0)&0xFF,((0) < 64*4 ? (0) : (256<<6)),255,  7,0,255,0,0,          (((uint32_t)(19 *1000L))&0xFF), (((uint32_t)(19 *1000L))>>8),(((uint32_t)(2 *1000L))&0xFF), (((uint32_t)(2 *1000L))>>8),(((uint32_t)(5 *1000L))&0xFF), (((uint32_t)(5 *1000L))>>8),(((uint32_t)(4 *1000L))&0xFF), (((uint32_t)(4 *1000L))>>8),(((uint32_t)(28))&0xFF), (((uint32_t)(28))>>8), 0,32,48,24,8,2,133,2,33,144,72,32,2,145,8,36,16,10,129,2,193,32,48,16,8,0,0,0,
  1, (((uint32_t)(9))&0xFF), (((uint32_t)(9))>>8)+0,(2 + (1<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 30,
  1, (((uint32_t)(10))&0xFF), (((uint32_t)(10))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 30,
  138,     (((uint32_t)(11))&0xFF), (((uint32_t)(11))>>8)+1 + 156 - 157+1 + 158 - 159,((0) < 64*4 ? (0) : (256<<6)),2,     2,0,      0,      2, 44, 45,

  138,     (((uint32_t)(11))&0xFF), (((uint32_t)(11))>>8)+1 + 160 - 161+1 + 162 - 163,((0) < 64*4 ? (0) : (256<<6)),2,     4,15,      60,      5, 46, 55, 59, 57, 19,
  138,     (((uint32_t)(14))&0xFF), (((uint32_t)(14))>>8)+1 + 164 - 165+1 + 166 - 167,((0) < 64*4 ? (0) : (256<<6)),2,     3,15,      45,      7, 58, 59, 60, 19, 23, 19, 44,

  1, (((uint32_t)(18))&0xFF), (((uint32_t)(18))>>8)+0,(1 + (2<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 25,
  138,     (((uint32_t)(19))&0xFF), (((uint32_t)(19))>>8)+1 + 170 - 171+1 + 172 - 173,((0) < 64*4 ? (0) : (256<<6)),2,     4,15,      45,      5, 44, 59, 60, (20 +1 + 168 - 169), 23,
  138,     (((uint32_t)(22))&0xFF), (((uint32_t)(22))>>8)+1 + 174 - 175+1 + 176 - 177,((0) < 64*4 ? (0) : (256<<6)),2,     2,0,      0,      2, 63, 64,

  138,     (((uint32_t)(22))&0xFF), (((uint32_t)(22))>>8)+1 + 178 - 179+1 + 180 - 181,((0) < 64*4 ? (0) : (256<<6)),1,     1,50,150,1, 38,
  138,     (((uint32_t)(23))&0xFF), (((uint32_t)(23))>>8)+1 + 182 - 183+1 + 184 - 185,((0) < 64*4 ? (0) : (256<<6)),5,     5,0,      0,      5, 63, 64, 60, 58, 33,
  138,     (((uint32_t)(25))&0xFF), (((uint32_t)(25))>>8)+1 + 188 - 189+1 + 190 - 191,((0) < 64*4 ? (0) : (256<<6)),0,     2,15,      45,      5, 55, 59, 57, 19, (17 +1 + 186 - 187),
  138,     (((uint32_t)(28))&0xFF), (((uint32_t)(28))>>8)+1 + 192 - 193+1 + 194 - 195,((0) < 64*4 ? (0) : (256<<6)),1,     1,0,      1,      1, 36,

  1, (((uint32_t)(28))&0xFF), (((uint32_t)(28))>>8)+0,(2 + (1<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 25,
  1, (((uint32_t)(29))&0xFF), (((uint32_t)(29))>>8)+0,(2 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 25,

  138,     (((uint32_t)(29))&0xFF), (((uint32_t)(29))>>8)+1 + 196 - 197+1 + 198 - 199,((0) < 64*4 ? (0) : (256<<6)),10,     10,0,      0,      10, 46, 44, 45, 46, 44, 45, 46, 44, 45, 46,
  170+1 + 200 - 201+1 + 202 - 203+1 + 204 - 205, 74,  (((uint32_t)(33))&0xFF), (((uint32_t)(33))>>8)+1 + 206 - 207+1 + 208 - 209+1 + 210 - 211+1 + 212 - 213+1 + 214 - 215+1 + 216 - 217+1 + 218 - 219,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(33))&0xFF), (((uint32_t)(33))>>8)+1 + 220 - 221+1 + 222 - 223+1 + 224 - 225+1 + 226 - 227+1 + 228 - 229+1 + 230 - 231+1 + 232 - 233,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 234 - 235+1 + 236 - 237+1 + 238 - 239, 74,  (((uint32_t)(34))&0xFF), (((uint32_t)(34))>>8)+1 + 240 - 241+1 + 242 - 243+1 + 244 - 245+1 + 246 - 247+1 + 248 - 249+1 + 250 - 251+1 + 252 - 253,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(34))&0xFF), (((uint32_t)(34))>>8)+1 + 254 - 255+1 + 256 - 257+1 + 258 - 259+1 + 260 - 261+1 + 262 - 263+1 + 264 - 265+1 + 266 - 267,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 268 - 269+1 + 270 - 271+1 + 272 - 273, 74,  (((uint32_t)(35))&0xFF), (((uint32_t)(35))>>8)+1 + 274 - 275+1 + 276 - 277+1 + 278 - 279+1 + 280 - 281+1 + 282 - 283+1 + 284 - 285+1 + 286 - 287,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(35))&0xFF), (((uint32_t)(35))>>8)+1 + 288 - 289+1 + 290 - 291+1 + 292 - 293+1 + 294 - 295+1 + 296 - 297+1 + 298 - 299+1 + 300 - 301,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  1, (((uint32_t)(36))&0xFF), (((uint32_t)(36))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 20,
  1, (((uint32_t)(37))&0xFF), (((uint32_t)(37))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 20,
  1, (((uint32_t)(38))&0xFF), (((uint32_t)(38))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 20,
  1, (((uint32_t)(39))&0xFF), (((uint32_t)(39))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 20,

  1, (((uint32_t)(41))&0xFF), (((uint32_t)(41))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 50,
  1, (((uint32_t)(42))&0xFF), (((uint32_t)(42))>>8)+0,(2 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 50,
  1, (((uint32_t)(42))&0xFF), (((uint32_t)(42))>>8)+0,(1 + (2<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 20,
  1, (((uint32_t)(43))&0xFF), (((uint32_t)(43))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 50,
  1, (((uint32_t)(44))&0xFF), (((uint32_t)(44))>>8)+0,(2 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 50,
  1, (((uint32_t)(44))&0xFF), (((uint32_t)(44))>>8)+0,(1 + (2<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 20,
  1, (((uint32_t)(45))&0xFF), (((uint32_t)(45))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 50,
  1, (((uint32_t)(46))&0xFF), (((uint32_t)(46))>>8)+0,(1 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 50,
  1, (((uint32_t)(46))&0xFF), (((uint32_t)(46))>>8)+0,(2 + (1<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 20,
  1, (((uint32_t)(47))&0xFF), (((uint32_t)(47))>>8)+0,(2 + (0<<2)),((255) < 64*4 ? (255) : (256<<6)),0, 127,
  138,     (((uint32_t)(48))&0xFF), (((uint32_t)(48))>>8)+1 + 306 - 307+1 + 308 - 309,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  2, (62+1 + 302 - 303), (62+1 + 304 - 305),
  1, (((uint32_t)(50))&0xFF), (((uint32_t)(50))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 32,
  1, (((uint32_t)(51))&0xFF), (((uint32_t)(51))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 32,
  1, (((uint32_t)(52))&0xFF), (((uint32_t)(52))>>8)+0,(2 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 32,
  1, (((uint32_t)(52))&0xFF), (((uint32_t)(52))>>8)+0,(1 + (2<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 25,
  1, (((uint32_t)(53))&0xFF), (((uint32_t)(53))>>8)+0,(3 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 25,
  1, (((uint32_t)(54))&0xFF), (((uint32_t)(54))>>8)+0,(1 + (0<<2)),((1) < 64*4 ? (1) : (256<<6)),0, 255,
  1, (((uint32_t)(54))&0xFF), (((uint32_t)(54))>>8)+0,(1 + (1<<2)),((2) < 64*4 ? (2) : (256<<6)),0, 255,
  1, (((uint32_t)(54))&0xFF), (((uint32_t)(54))>>8)+0,(1 + (2<<2)),((3) < 64*4 ? (3) : (256<<6)),0, 255,
  1, (((uint32_t)(55))&0xFF), (((uint32_t)(55))>>8)+0,(1 + (0<<2)),((4) < 64*4 ? (4) : (256<<6)),0, 255,
  1, (((uint32_t)(55))&0xFF), (((uint32_t)(55))>>8)+0,(2 + (1<<2)),((5) < 64*4 ? (5) : (256<<6)),0, 255,
  1, (((uint32_t)(56))&0xFF), (((uint32_t)(56))>>8)+0,(1 + (2<<2)),((5) < 64*4 ? (5) : (256<<6)),0, 255,

  1, (((uint32_t)(55))&0xFF), (((uint32_t)(55))>>8)+0,(2 + (1<<2)),((6) < 64*4 ? (6) : (256<<6)),0, 255,
  1, (((uint32_t)(56))&0xFF), (((uint32_t)(56))>>8)+0,(3 + (0<<2)),((6) < 64*4 ? (6) : (256<<6)),0, 255,

  1, (((uint32_t)(56))&0xFF), (((uint32_t)(56))>>8)+0,(1 + (2<<2)),((7) < 64*4 ? (7) : (256<<6)),0, 255,
  170+1 + 310 - 311+1 + 312 - 313+1 + 314 - 315, 74,  (((uint32_t)(57))&0xFF), (((uint32_t)(57))>>8)+1 + 316 - 317+1 + 318 - 319+1 + 320 - 321+1 + 322 - 323+1 + 324 - 325+1 + 326 - 327+1 + 328 - 329,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(57))&0xFF), (((uint32_t)(57))>>8)+1 + 330 - 331+1 + 332 - 333+1 + 334 - 335+1 + 336 - 337+1 + 338 - 339+1 + 340 - 341+1 + 342 - 343,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 344 - 345+1 + 346 - 347+1 + 348 - 349, 74,  (((uint32_t)(58))&0xFF), (((uint32_t)(58))>>8)+1 + 350 - 351+1 + 352 - 353+1 + 354 - 355+1 + 356 - 357+1 + 358 - 359+1 + 360 - 361+1 + 362 - 363,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(58))&0xFF), (((uint32_t)(58))>>8)+1 + 364 - 365+1 + 366 - 367+1 + 368 - 369+1 + 370 - 371+1 + 372 - 373+1 + 374 - 375+1 + 376 - 377,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 378 - 379+1 + 380 - 381+1 + 382 - 383, 74,  (((uint32_t)(59))&0xFF), (((uint32_t)(59))>>8)+1 + 384 - 385+1 + 386 - 387+1 + 388 - 389+1 + 390 - 391+1 + 392 - 393+1 + 394 - 395+1 + 396 - 397,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(59))&0xFF), (((uint32_t)(59))>>8)+1 + 398 - 399+1 + 400 - 401+1 + 402 - 403+1 + 404 - 405+1 + 406 - 407+1 + 408 - 409+1 + 410 - 411,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 412 - 413+1 + 414 - 415+1 + 416 - 417, 74,  (((uint32_t)(60))&0xFF), (((uint32_t)(60))>>8)+1 + 418 - 419+1 + 420 - 421+1 + 422 - 423+1 + 424 - 425+1 + 426 - 427+1 + 428 - 429+1 + 430 - 431,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(60))&0xFF), (((uint32_t)(60))>>8)+1 + 432 - 433+1 + 434 - 435+1 + 436 - 437+1 + 438 - 439+1 + 440 - 441+1 + 442 - 443+1 + 444 - 445,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  1, (((uint32_t)(61))&0xFF), (((uint32_t)(61))>>8)+0,(1 + (0<<2)),((8) < 64*4 ? (8) : (256<<6)),0, 255,
  1, (((uint32_t)(61))&0xFF), (((uint32_t)(61))>>8)+0,(1 + (2<<2)),((8) < 64*4 ? (8) : (256<<6)),0, 255,
  183, 0, 40, 40, 80, 90, 130, 150, 150, 0,
  138,     (((uint32_t)(62))&0xFF), (((uint32_t)(62))>>8)+1 + 450 - 451+1 + 452 - 453,((8) < 64*4 ? (8) : (256<<6)),127,        255,     2,  5,  2, (62+1 + 446 - 447), (62+1 + 448 - 449),
  138,     (((uint32_t)(64))&0xFF), (((uint32_t)(64))>>8)+1 + 454 - 455+1 + 456 - 457,((8) < 64*4 ? (8) : (256<<6)),127,        255,     2,  5,  6, 28, 29, 30, 36, 37, 38,
  183, 25, 25, 80, 100, 120, 145, 64, 50, 5,
  138,     (((uint32_t)(66))&0xFF), (((uint32_t)(66))>>8)+1 + 458 - 459+1 + 460 - 461,((0) < 64*4 ? (0) : (256<<6)),4,     8,5,      15,      16, 58, 59, 60, 58, 59, 60, 0, 58, 59, 60, 58, 59, 60, 58, 59, 60,
  138,     (((uint32_t)(72))&0xFF), (((uint32_t)(72))>>8)+1 + 462 - 463+1 + 464 - 465,((0) < 64*4 ? (0) : (256<<6)),6,     6,0,      0,      6, 28, 59, 60, 58, 59, 60,
  138,     (((uint32_t)(74))&0xFF), (((uint32_t)(74))>>8)+1 + 466 - 467+1 + 468 - 469,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  3, 63, 64, 65,
  138,     (((uint32_t)(75))&0xFF), (((uint32_t)(75))>>8)+1 + 470 - 471+1 + 472 - 473,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  3, 55, 56, 57,
  183, 35, 60, 80, 100, 120, 145, 64, 50, 5,

  138,     (((uint32_t)(77))&0xFF), (((uint32_t)(77))>>8)+1 + 478 - 479+1 + 480 - 481,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  2, (62+1 + 474 - 475), (62+1 + 476 - 477),

  183, 25, 25, 80, 100, 120, 145, 64, 50, 5,
  138,     (((uint32_t)(80))&0xFF), (((uint32_t)(80))>>8)+1 + 486 - 487+1 + 488 - 489,((0) < 64*4 ? (0) : (256<<6)),2,     2,0,      0,      2, (62+1 + 482 - 483), (62+1 + 484 - 485),

  173,      9, (4-1),
  74,  (((uint32_t)(82))&0xFF), (((uint32_t)(82))>>8)+1 + 490 - 491+1 + 492 - 493+1 + 494 - 495+1 + 496 - 497+1 + 498 - 499+1 + 500 - 501+1 + 502 - 503+1 + 504 - 505+1 + 506 - 507+1 + 508 - 509+1 + 510 - 511+1 + 512 - 513+1 + 514 - 515+1 + 516 - 517+1 + 518 - 519+1 + 520 - 521+1 + 522 - 523+1 + 524 - 525+1 + 526 - 527+1 + 528 - 529+1 + 530 - 531+1 + 532 - 533+1 + 534 - 535+1 + 536 - 537+1 + 538 - 539,(28)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  18,0,255,0,0|0x08,(((uint32_t)(3 *1000L))&0xFF), (((uint32_t)(3 *1000L))>>8),(((uint32_t)(266))&0xFF), (((uint32_t)(266))>>8), 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,13,5,15,13,5,15,13,5,15,13,5,15,13,5,15,13,5,0,0,150,30,0,60,50,0,0,30,30,0,0,55,0,0,25,50,30,0,60,50,0,0,30,30,0,0,55,0,0,25,50,0,0,150,50,0,0,30,30,0,0,55,0,0,25,50,0,0,150,30,0,60,30,30,0,0,55,0,0,25,50,0,0,150,30,0,60,50,0,0,0,55,0,0,25,50,0,0,150,30,0,60,50,0,0,30,30,0,0,25,50,0,0,150,30,0,60,50,0,0,30,30,0,0,55,0,0,0,150,0,0,150,0,0,150,0,0,150,0,0,150,0,0,150,30,0,60,30,0,60,30,0,60,30,0,60,30,0,60,30,0,60,55,0,0,55,0,0,55,0,0,55,0,0,55,0,0,55,0,0,30,30,0,30,30,0,30,30,0,30,30,0,30,30,0,30,30,0,0,55,0,0,55,0,0,55,0,0,55,0,0,55,0,0,55,0,0,25,50,0,25,50,0,25,50,0,25,50,0,25,50,0,25,50  ,63,191,192,0,0,0,0,1,192,0,0,0,0,2,
  143,   1,       (((uint32_t)(88))&0xFF), (((uint32_t)(88))>>8), 255, (((uint32_t)(81))&0xFF), (((uint32_t)(81))>>8),
  143,   1,       (((uint32_t)(89))&0xFF), (((uint32_t)(89))>>8), 255, (((uint32_t)(81))&0xFF), (((uint32_t)(81))>>8),
  143,   1,       (((uint32_t)(90))&0xFF), (((uint32_t)(90))>>8), 255, (((uint32_t)(86))&0xFF), (((uint32_t)(86))>>8),
  143,   1,       (((uint32_t)(91))&0xFF), (((uint32_t)(91))>>8), 255, (((uint32_t)(85))&0xFF), (((uint32_t)(85))>>8),
  143,   1,       (((uint32_t)(92))&0xFF), (((uint32_t)(92))>>8), 255, (((uint32_t)(84))&0xFF), (((uint32_t)(84))>>8),
  143,   1,       (((uint32_t)(93))&0xFF), (((uint32_t)(93))>>8), 255, (((uint32_t)(83))&0xFF), (((uint32_t)(83))>>8),
  143,   1,       (((uint32_t)(94))&0xFF), (((uint32_t)(94))>>8), 255, (((uint32_t)(82))&0xFF), (((uint32_t)(82))>>8),
  143,   1,       (((uint32_t)(95))&0xFF), (((uint32_t)(95))>>8), 255, (((uint32_t)(81))&0xFF), (((uint32_t)(81))>>8),
  143,   1,       (((uint32_t)(96))&0xFF), (((uint32_t)(96))>>8), 255, (((uint32_t)(81))&0xFF), (((uint32_t)(81))>>8),
  170+1 + 540 - 541+1 + 542 - 543+1 + 544 - 545, 74,  (((uint32_t)(97))&0xFF), (((uint32_t)(97))>>8)+1 + 546 - 547+1 + 548 - 549+1 + 550 - 551+1 + 552 - 553+1 + 554 - 555+1 + 556 - 557+1 + 558 - 559,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(97))&0xFF), (((uint32_t)(97))>>8)+1 + 560 - 561+1 + 562 - 563+1 + 564 - 565+1 + 566 - 567+1 + 568 - 569+1 + 570 - 571+1 + 572 - 573,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 574 - 575+1 + 576 - 577+1 + 578 - 579, 74,  (((uint32_t)(98))&0xFF), (((uint32_t)(98))>>8)+1 + 580 - 581+1 + 582 - 583+1 + 584 - 585+1 + 586 - 587+1 + 588 - 589+1 + 590 - 591+1 + 592 - 593,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(98))&0xFF), (((uint32_t)(98))>>8)+1 + 594 - 595+1 + 596 - 597+1 + 598 - 599+1 + 600 - 601+1 + 602 - 603+1 + 604 - 605+1 + 606 - 607,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  138,     (((uint32_t)(99))&0xFF), (((uint32_t)(99))>>8)+1 + 608 - 609+1 + 610 - 611,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  3, 44, 59, 60,

  140,    21 +1 + 612 - 613+1 + 614 - 615+1 + 616 - 617+1 + 618 - 619,          13, (0b00000000) | ((((((((((40))))<65536)?1:0) * ((((((60))))<65536)?1:0)  * (((((((40))))+((((60)))))<65536)?1:0))) * (((((((1 )))<65536)?1:0) * (((((1 )))<65536)?1:0)  * ((((((1 )))+(((1 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((40)/((((((((((40))))<65536)?1:0) * ((((((60))))<65536)?1:0)  * (((((((40))))+((((60)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((40)/((((((((((40))))<65536)?1:0) * ((((((60))))<65536)?1:0)  * (((((((40))))+((((60)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((60)/((((((((((60))))<65536)?1:0) * ((((((40))))<65536)?1:0)  * (((((((60))))+((((40)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((60)/((((((((((60))))<65536)?1:0) * ((((((40))))<65536)?1:0)  * (((((((60))))+((((40)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((40))))<65536)?1:0) * ((((((60))))<65536)?1:0)  * (((((((40))))+((((60)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((40))))<65536)?1:0) * ((((((60))))<65536)?1:0)  * (((((((40))))+((((60)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((40))))<65536)?1:0) * ((((((60))))<65536)?1:0)  * (((((((40))))+((((60)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((40))))<65536)?1:0) * ((((((60))))<65536)?1:0)  * (((((((40))))+((((60)))))<65536)?1:0))))?1L:16L)))>>8),
  171+1 + 620 - 621+1 + 622 - 623,

  144,   (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))&0xFF), (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))>>8), 21+1 + 624 - 625+1 + 626 - 627+1 + 628 - 629, 13, (((uint32_t)((0 *1000L)/16))&0xFF), (((uint32_t)((0 *1000L)/16))>>8), 1, 20,
  10,  (((uint32_t)(100))&0xFF), (((uint32_t)(100))>>8)+1 + 630 - 631+1 + 632 - 633+1 + 634 - 635+1 + 636 - 637+1 + 638 - 639,           (4)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,150,0,0,          (((uint32_t)(60))&0xFF), (((uint32_t)(60))>>8),(((uint32_t)(35))&0xFF), (((uint32_t)(35))>>8), 64,85,85,85,85,21,17,85,102,86,221,93,85,17,81  ,63,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,
  74,  (((uint32_t)(101))&0xFF), (((uint32_t)(101))>>8)+1 + 640 - 641+1 + 642 - 643+1 + 644 - 645+1 + 646 - 647+1 + 648 - 649+1 + 650 - 651+1 + 652 - 653,           (4)&0xFF,((14) < 64*4 ? (14) : (256<<6)),255,  4,0,60,0,0,          (((uint32_t)(32))&0xFF), (((uint32_t)(32))>>8),(((uint32_t)(10))&0xFF), (((uint32_t)(10))>>8), 52,112,208,192,64,1,3,7,13,28,

  1, (((uint32_t)(102))&0xFF), (((uint32_t)(102))>>8)+0,(1 + (1<<2)),((15) < 64*4 ? (15) : (256<<6)),0, 255,
  11,  (((uint32_t)(102))&0xFF), (((uint32_t)(102))>>8)+1 + 654 - 655+1 + 656 - 657+1 + 658 - 659+1 + 660 - 661+1 + 662 - 663,           ((((((1 + (2<<2)))>>2)&0x03) + ((1-1)<<2) + (((2<=2?(8-((((1 + (2<<2)))&0x03))*2):(((((1 + (2<<2)))&0x03))==2?0:4))&0x07)<<5)))&0xFF,((15) < 64*4 ? (15) : (256<<6)),255,  (((1 + (2<<2)))&0x03),0,255,0,0x40,          (((uint32_t)(1 *1000L/16))&0xFF), (((uint32_t)(1 *1000L/16))>>8),(((uint32_t)(12 *1000L/16))&0xFF), (((uint32_t)(12 *1000L/16))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),            ((((((1 + (2<<2)))&0x03))==1?0b00000001: (((((1 + (2<<2)))&0x03))==2?0b00000011:0b00000111))),

  174,  13, (1-1),
  10,  (((uint32_t)(103))&0xFF), (((uint32_t)(103))>>8)+1 + 664 - 665+1 + 666 - 667+1 + 668 - 669+1 + 670 - 671+1 + 672 - 673,           (196)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,40,0,0,          (((uint32_t)(15 *1000L))&0xFF), (((uint32_t)(15 *1000L))>>8),(((uint32_t)(6))&0xFF), (((uint32_t)(6))>>8), 2,192,3  ,0,63,191,

  180, 15,13,3,22,44,27,155,73,5,39,18,1,30,0,0,79,39,7,50,50,50,255,255,255,20,20,27,75,100,99,245,245,255,50,50,20,70,70,30,50,50,8,50,50,8,255,255,255,50,50,50,
#line 365 "D:\data\doc\GitHub\pyMobaLedLib\python\LEDs_AutoProg\LEDs_AutoProg.h"
  184,     60, 1, 0,
  184,     61, 1, 16,
  184,     62, 1, 7,
  184,     63, 1, 5,
  184,     64, 1, 6,
  184,     65, 9, 60 , 255, 61 , 255, 62 , 255, 63 , 255, 64,
  184,     66, 7, 61 , 255, 62 , 255, 63 , 255, 64,
  184,     67, 7, 62 , 255, 61 , 255, 63 , 255, 64,
  184,     68, 7, 63 , 255, 61 , 255, 62 , 255, 64,
  184,     69, 7, 64 , 255, 62 , 255, 63 , 255, 61,
  184,     70, 17, 61 , 62 ,254, 61 , 63 ,254, 61 , 64 ,254, 62 , 63 ,254, 62 , 64 ,254, 63 , 64,
  138,     (((uint32_t)(104))&0xFF), (((uint32_t)(104))>>8)+1 + 674 - 675+1 + 676 - 677,((65) < 64*4 ? (65) : (256<<6)),6,     6,0,      1,      6, 43, 43, 43, 43, 43, 43,

  140,    22 +1 + 678 - 679+1 + 680 - 681+1 + 682 - 683+1 + 684 - 685,          66, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(104))&0xFF), (((uint32_t)(104))>>8)+0,(1 + (1<<2)),((22) < 64*4 ? (22) : (256<<6)),0, 255,
  140,    23 +1 + 686 - 687+1 + 688 - 689+1 + 690 - 691+1 + 692 - 693,          66, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(105))&0xFF), (((uint32_t)(105))>>8)+0,(1 + (1<<2)),((23) < 64*4 ? (23) : (256<<6)),0, 255,
  140,    24 +1 + 694 - 695+1 + 696 - 697+1 + 698 - 699+1 + 700 - 701,          66, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(106))&0xFF), (((uint32_t)(106))>>8)+0,(1 + (1<<2)),((24) < 64*4 ? (24) : (256<<6)),0, 255,
  140,    25 +1 + 702 - 703+1 + 704 - 705+1 + 706 - 707+1 + 708 - 709,          66, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(107))&0xFF), (((uint32_t)(107))>>8)+0,(1 + (1<<2)),((25) < 64*4 ? (25) : (256<<6)),0, 255,
  140,    26 +1 + 710 - 711+1 + 712 - 713+1 + 714 - 715+1 + 716 - 717,          66, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(108))&0xFF), (((uint32_t)(108))>>8)+0,(1 + (1<<2)),((26) < 64*4 ? (26) : (256<<6)),0, 255,
  140,    27 +1 + 718 - 719+1 + 720 - 721+1 + 722 - 723+1 + 724 - 725,          66, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(109))&0xFF), (((uint32_t)(109))>>8)+0,(1 + (1<<2)),((27) < 64*4 ? (27) : (256<<6)),0, 255,

  140,    28 +1 + 726 - 727+1 + 728 - 729+1 + 730 - 731+1 + 732 - 733,          67, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(104))&0xFF), (((uint32_t)(104))>>8)+0,(2 + (1<<2)),((28) < 64*4 ? (28) : (256<<6)),0, 255,
  140,    29 +1 + 734 - 735+1 + 736 - 737+1 + 738 - 739+1 + 740 - 741,          67, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(105))&0xFF), (((uint32_t)(105))>>8)+0,(2 + (1<<2)),((29) < 64*4 ? (29) : (256<<6)),0, 255,
  140,    30 +1 + 742 - 743+1 + 744 - 745+1 + 746 - 747+1 + 748 - 749,          67, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(106))&0xFF), (((uint32_t)(106))>>8)+0,(2 + (1<<2)),((30) < 64*4 ? (30) : (256<<6)),0, 255,
  140,    31 +1 + 750 - 751+1 + 752 - 753+1 + 754 - 755+1 + 756 - 757,          67, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(107))&0xFF), (((uint32_t)(107))>>8)+0,(2 + (1<<2)),((31) < 64*4 ? (31) : (256<<6)),0, 255,
  140,    32 +1 + 758 - 759+1 + 760 - 761+1 + 762 - 763+1 + 764 - 765,          67, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(108))&0xFF), (((uint32_t)(108))>>8)+0,(2 + (1<<2)),((32) < 64*4 ? (32) : (256<<6)),0, 255,
  140,    33 +1 + 766 - 767+1 + 768 - 769+1 + 770 - 771+1 + 772 - 773,          67, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(109))&0xFF), (((uint32_t)(109))>>8)+0,(2 + (1<<2)),((33) < 64*4 ? (33) : (256<<6)),0, 255,

  140,    34 +1 + 774 - 775+1 + 776 - 777+1 + 778 - 779+1 + 780 - 781,          68, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(104))&0xFF), (((uint32_t)(104))>>8)+0,(2 + (0<<2)),((34) < 64*4 ? (34) : (256<<6)),0, 255,
  140,    35 +1 + 782 - 783+1 + 784 - 785+1 + 786 - 787+1 + 788 - 789,          68, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(105))&0xFF), (((uint32_t)(105))>>8)+0,(2 + (0<<2)),((35) < 64*4 ? (35) : (256<<6)),0, 255,
  140,    36 +1 + 790 - 791+1 + 792 - 793+1 + 794 - 795+1 + 796 - 797,          68, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(106))&0xFF), (((uint32_t)(106))>>8)+0,(2 + (0<<2)),((36) < 64*4 ? (36) : (256<<6)),0, 255,
  140,    37 +1 + 798 - 799+1 + 800 - 801+1 + 802 - 803+1 + 804 - 805,          68, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(107))&0xFF), (((uint32_t)(107))>>8)+0,(2 + (0<<2)),((37) < 64*4 ? (37) : (256<<6)),0, 255,
  140,    38 +1 + 806 - 807+1 + 808 - 809+1 + 810 - 811+1 + 812 - 813,          68, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(108))&0xFF), (((uint32_t)(108))>>8)+0,(2 + (0<<2)),((38) < 64*4 ? (38) : (256<<6)),0, 255,
  140,    39 +1 + 814 - 815+1 + 816 - 817+1 + 818 - 819+1 + 820 - 821,          68, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(109))&0xFF), (((uint32_t)(109))>>8)+0,(2 + (0<<2)),((39) < 64*4 ? (39) : (256<<6)),0, 255,

  140,    40 +1 + 822 - 823+1 + 824 - 825+1 + 826 - 827+1 + 828 - 829,          69, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(104))&0xFF), (((uint32_t)(104))>>8)+0,(3 + (0<<2)),((40) < 64*4 ? (40) : (256<<6)),0, 255,
  140,    41 +1 + 830 - 831+1 + 832 - 833+1 + 834 - 835+1 + 836 - 837,          69, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(105))&0xFF), (((uint32_t)(105))>>8)+0,(3 + (0<<2)),((41) < 64*4 ? (41) : (256<<6)),0, 255,
  140,    42 +1 + 838 - 839+1 + 840 - 841+1 + 842 - 843+1 + 844 - 845,          69, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(106))&0xFF), (((uint32_t)(106))>>8)+0,(3 + (0<<2)),((42) < 64*4 ? (42) : (256<<6)),0, 255,
  140,    43 +1 + 846 - 847+1 + 848 - 849+1 + 850 - 851+1 + 852 - 853,          69, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(107))&0xFF), (((uint32_t)(107))>>8)+0,(3 + (0<<2)),((43) < 64*4 ? (43) : (256<<6)),0, 255,
  140,    44 +1 + 854 - 855+1 + 856 - 857+1 + 858 - 859+1 + 860 - 861,          69, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(108))&0xFF), (((uint32_t)(108))>>8)+0,(3 + (0<<2)),((44) < 64*4 ? (44) : (256<<6)),0, 255,
  140,    45 +1 + 862 - 863+1 + 864 - 865+1 + 866 - 867+1 + 868 - 869,          69, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(109))&0xFF), (((uint32_t)(109))>>8)+0,(3 + (0<<2)),((45) < 64*4 ? (45) : (256<<6)),0, 255,

  140,    46 +1 + 870 - 871+1 + 872 - 873+1 + 874 - 875+1 + 876 - 877,          70, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(104))&0xFF), (((uint32_t)(104))>>8)+0,(1 + (0<<2)),((46) < 64*4 ? (46) : (256<<6)),0, 255,
  140,    47 +1 + 878 - 879+1 + 880 - 881+1 + 882 - 883+1 + 884 - 885,          70, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(105))&0xFF), (((uint32_t)(105))>>8)+0,(1 + (0<<2)),((47) < 64*4 ? (47) : (256<<6)),0, 255,
  140,    48 +1 + 886 - 887+1 + 888 - 889+1 + 890 - 891+1 + 892 - 893,          70, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(106))&0xFF), (((uint32_t)(106))>>8)+0,(1 + (0<<2)),((48) < 64*4 ? (48) : (256<<6)),0, 255,
  140,    49 +1 + 894 - 895+1 + 896 - 897+1 + 898 - 899+1 + 900 - 901,          70, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(107))&0xFF), (((uint32_t)(107))>>8)+0,(1 + (0<<2)),((49) < 64*4 ? (49) : (256<<6)),0, 255,
  140,    50 +1 + 902 - 903+1 + 904 - 905+1 + 906 - 907+1 + 908 - 909,          70, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(108))&0xFF), (((uint32_t)(108))>>8)+0,(1 + (0<<2)),((50) < 64*4 ? (50) : (256<<6)),0, 255,
  140,    51 +1 + 910 - 911+1 + 912 - 913+1 + 914 - 915+1 + 916 - 917,          70, (0b00000000) | ((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * (((((((30 )))<65536)?1:0) * (((((30 )))<65536)?1:0)  * ((((((30 )))+(((30 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((500)/((((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))) * ((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30)/((((((((((30))))<65536)?1:0) * ((((((30))))<65536)?1:0)  * (((((((30))))+((((30)))))<65536)?1:0))) * ((((((((500))))<65536)?1:0) * ((((((500))))<65536)?1:0)  * (((((((500))))+((((500)))))<65536)?1:0))))?1L:16L)))>>8), 1, (((uint32_t)(109))&0xFF), (((uint32_t)(109))>>8)+0,(1 + (0<<2)),((51) < 64*4 ? (51) : (256<<6)),0, 255,

  140,    52 +1 + 918 - 919+1 + 920 - 921+1 + 922 - 923+1 + 924 - 925,          13, (0b00000000) | ((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * (((((((1 )))<65536)?1:0) * (((((1 )))<65536)?1:0)  * ((((((1 )))+(((1 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8),
  171+1 + 926 - 927+1 + 928 - 929,

  144,   (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))&0xFF), (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))>>8), 52+1 + 930 - 931+1 + 932 - 933+1 + 934 - 935, 13, (((uint32_t)((0 *1000L)/16))&0xFF), (((uint32_t)((0 *1000L)/16))>>8), 1, 14,
  23, (((uint32_t)(110))&0xFF), (((uint32_t)(110))>>8)+1 + 936 - 937+1 + 938 - 939+1 + 940 - 941+1 + 942 - 943+1 + 944 - 945,           (68)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,40,0,0,          (((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(30))&0xFF), (((uint32_t)(30))>>8), 192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191,

  140,    53 +1 + 946 - 947+1 + 948 - 949+1 + 950 - 951+1 + 952 - 953,          13, (0b00000000) | ((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * (((((((1 )))<65536)?1:0) * (((((1 )))<65536)?1:0)  * ((((((1 )))+(((1 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8),
  171+1 + 954 - 955+1 + 956 - 957,

  144,   (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))&0xFF), (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))>>8), 53+1 + 958 - 959+1 + 960 - 961+1 + 962 - 963, 13, (((uint32_t)((0 *1000L)/16))&0xFF), (((uint32_t)((0 *1000L)/16))>>8), 1, 14,
  23, (((uint32_t)(111))&0xFF), (((uint32_t)(111))>>8)+1 + 964 - 965+1 + 966 - 967+1 + 968 - 969+1 + 970 - 971+1 + 972 - 973,           (68)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,40,0,0,          (((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(30))&0xFF), (((uint32_t)(30))>>8), 192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191,

  140,    54 +1 + 974 - 975+1 + 976 - 977+1 + 978 - 979+1 + 980 - 981,          13, (0b00000000) | ((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * (((((((1 )))<65536)?1:0) * (((((1 )))<65536)?1:0)  * ((((((1 )))+(((1 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8),
  171+1 + 982 - 983+1 + 984 - 985,

  144,   (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))&0xFF), (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))>>8), 54+1 + 986 - 987+1 + 988 - 989+1 + 990 - 991, 13, (((uint32_t)((0 *1000L)/16))&0xFF), (((uint32_t)((0 *1000L)/16))>>8), 1, 14,
  23, (((uint32_t)(112))&0xFF), (((uint32_t)(112))>>8)+1 + 992 - 993+1 + 994 - 995+1 + 996 - 997+1 + 998 - 999+1 + 1000 - 1001,           (68)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,40,0,0,          (((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(30))&0xFF), (((uint32_t)(30))>>8), 192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191,
  11,  (((uint32_t)(113))&0xFF), (((uint32_t)(113))>>8)+1 + 1002 - 1003+1 + 1004 - 1005+1 + 1006 - 1007+1 + 1008 - 1009+1 + 1010 - 1011,           ((((((1 + (0<<2)))>>2)&0x03) + ((1-1)<<2) + (((2<=2?(8-((((1 + (0<<2)))&0x03))*2):(((((1 + (0<<2)))&0x03))==2?0:4))&0x07)<<5)))&0xFF,((13) < 64*4 ? (13) : (256<<6)),255,  (((1 + (0<<2)))&0x03),0,40,0,0x40,          (((uint32_t)(0.02 *1000L/16))&0xFF), (((uint32_t)(0.02 *1000L/16))>>8),(((uint32_t)(0.7 *1000L/16))&0xFF), (((uint32_t)(0.7 *1000L/16))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),            ((((((1 + (0<<2)))&0x03))==1?0b00000001: (((((1 + (0<<2)))&0x03))==2?0b00000011:0b00000111))),

  140,    55 +1 + 1012 - 1013+1 + 1014 - 1015+1 + 1016 - 1017+1 + 1018 - 1019,          13, (0b00000000) | ((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * (((((((1 )))<65536)?1:0) * (((((1 )))<65536)?1:0)  * ((((((1 )))+(((1 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8),
  171+1 + 1020 - 1021+1 + 1022 - 1023,

  144,   (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))&0xFF), (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))>>8), 55+1 + 1024 - 1025+1 + 1026 - 1027+1 + 1028 - 1029, 13, (((uint32_t)((0 *1000L)/16))&0xFF), (((uint32_t)((0 *1000L)/16))>>8), 1, 14,
  23, (((uint32_t)(114))&0xFF), (((uint32_t)(114))>>8)+1 + 1030 - 1031+1 + 1032 - 1033+1 + 1034 - 1035+1 + 1036 - 1037+1 + 1038 - 1039,           (68)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,40,0,0,          (((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(30))&0xFF), (((uint32_t)(30))>>8), 192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191,

  140,    56 +1 + 1040 - 1041+1 + 1042 - 1043+1 + 1044 - 1045+1 + 1046 - 1047,          13, (0b00000000) | ((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * (((((((1 )))<65536)?1:0) * (((((1 )))<65536)?1:0)  * ((((((1 )))+(((1 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8),
  171+1 + 1048 - 1049+1 + 1050 - 1051,

  144,   (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))&0xFF), (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))>>8), 56+1 + 1052 - 1053+1 + 1054 - 1055+1 + 1056 - 1057, 13, (((uint32_t)((0 *1000L)/16))&0xFF), (((uint32_t)((0 *1000L)/16))>>8), 1, 14,
  23, (((uint32_t)(115))&0xFF), (((uint32_t)(115))>>8)+1 + 1058 - 1059+1 + 1060 - 1061+1 + 1062 - 1063+1 + 1064 - 1065+1 + 1066 - 1067,           (68)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,40,0,0,          (((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(30))&0xFF), (((uint32_t)(30))>>8), 192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191,

  140,    57 +1 + 1068 - 1069+1 + 1070 - 1071+1 + 1072 - 1073+1 + 1074 - 1075,          13, (0b00000000) | ((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * (((((((1 )))<65536)?1:0) * (((((1 )))<65536)?1:0)  * ((((((1 )))+(((1 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((12 *1000L)/((((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((30 *1000L)/((((((((((30 *1000L))))<65536)?1:0) * ((((((12 *1000L))))<65536)?1:0)  * (((((((30 *1000L))))+((((12 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((12 *1000L))))<65536)?1:0) * ((((((30 *1000L))))<65536)?1:0)  * (((((((12 *1000L))))+((((30 *1000L)))))<65536)?1:0))))?1L:16L)))>>8),
  171+1 + 1076 - 1077+1 + 1078 - 1079,

  144,   (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))&0xFF), (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))>>8), 57+1 + 1080 - 1081+1 + 1082 - 1083+1 + 1084 - 1085, 13, (((uint32_t)((0 *1000L)/16))&0xFF), (((uint32_t)((0 *1000L)/16))>>8), 1, 14,
  23, (((uint32_t)(116))&0xFF), (((uint32_t)(116))>>8)+1 + 1086 - 1087+1 + 1088 - 1089+1 + 1090 - 1091+1 + 1092 - 1093+1 + 1094 - 1095,           (68)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,40,0,0,          (((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),(((uint32_t)(30))&0xFF), (((uint32_t)(30))>>8), 192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191,
  183, 81, 100, 60, 160, 60, 72, 80, 50, 5,
  138,     (((uint32_t)(117))&0xFF), (((uint32_t)(117))>>8)+1 + 1096 - 1097+1 + 1098 - 1099,((13) < 64*4 ? (13) : (256<<6)),1,     1,2,      5,      1, 64,
  138,     (((uint32_t)(118))&0xFF), (((uint32_t)(118))>>8)+1 + 1100 - 1101+1 + 1102 - 1103,((13) < 64*4 ? (13) : (256<<6)),1,     1,2,      5,      1, 64,
  138,     (((uint32_t)(119))&0xFF), (((uint32_t)(119))>>8)+1 + 1104 - 1105+1 + 1106 - 1107,((13) < 64*4 ? (13) : (256<<6)),1,     1,2,      5,      1, 64,
  11,  (((uint32_t)(120))&0xFF), (((uint32_t)(120))>>8)+1 + 1108 - 1109+1 + 1110 - 1111+1 + 1112 - 1113+1 + 1114 - 1115+1 + 1116 - 1117,           (64)&0xFF,((13) < 64*4 ? (13) : (256<<6)),255,  3,0,80,0,0,          (((uint32_t)(800))&0xFF), (((uint32_t)(800))>>8),(((uint32_t)(200))&0xFF), (((uint32_t)(200))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 10,
  138,     (((uint32_t)(121))&0xFF), (((uint32_t)(121))>>8)+1 + 1118 - 1119+1 + 1120 - 1121,((13) < 64*4 ? (13) : (256<<6)),1,     1,2,      5,      1, 64,

  140,    58 +1 + 1122 - 1123+1 + 1124 - 1125+1 + 1126 - 1127+1 + 1128 - 1129,          13, (0b00000000) | ((((((((((5 *1000L))))<65536)?1:0) * ((((((8 *1000L))))<65536)?1:0)  * (((((((5 *1000L))))+((((8 *1000L)))))<65536)?1:0))) * (((((((1 )))<65536)?1:0) * (((((1 )))<65536)?1:0)  * ((((((1 )))+(((1 ))))<65536)?1:0))))?0:0b00000001), (((uint32_t)((5 *1000L)/((((((((((5 *1000L))))<65536)?1:0) * ((((((8 *1000L))))<65536)?1:0)  * (((((((5 *1000L))))+((((8 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((5 *1000L)/((((((((((5 *1000L))))<65536)?1:0) * ((((((8 *1000L))))<65536)?1:0)  * (((((((5 *1000L))))+((((8 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((8 *1000L)/((((((((((8 *1000L))))<65536)?1:0) * ((((((5 *1000L))))<65536)?1:0)  * (((((((8 *1000L))))+((((5 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((8 *1000L)/((((((((((8 *1000L))))<65536)?1:0) * ((((((5 *1000L))))<65536)?1:0)  * (((((((8 *1000L))))+((((5 *1000L)))))<65536)?1:0))) * ((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((5 *1000L))))<65536)?1:0) * ((((((8 *1000L))))<65536)?1:0)  * (((((((5 *1000L))))+((((8 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((5 *1000L))))<65536)?1:0) * ((((((8 *1000L))))<65536)?1:0)  * (((((((5 *1000L))))+((((8 *1000L)))))<65536)?1:0))))?1L:16L)))>>8), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((5 *1000L))))<65536)?1:0) * ((((((8 *1000L))))<65536)?1:0)  * (((((((5 *1000L))))+((((8 *1000L)))))<65536)?1:0))))?1L:16L)))&0xFF), (((uint32_t)((1)/((((((((((1))))<65536)?1:0) * ((((((1))))<65536)?1:0)  * (((((((1))))+((((1)))))<65536)?1:0))) * ((((((((5 *1000L))))<65536)?1:0) * ((((((8 *1000L))))<65536)?1:0)  * (((((((5 *1000L))))+((((8 *1000L)))))<65536)?1:0))))?1L:16L)))>>8),
  171+1 + 1130 - 1131+1 + 1132 - 1133,

  144,   (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))&0xFF), (((uint32_t)(((0b00000010<<8)|(0b00000100<<8)) | (0b00000001<<8) | 0b10000000))>>8), 58+1 + 1134 - 1135+1 + 1136 - 1137+1 + 1138 - 1139, 13, (((uint32_t)((0 *1000L)/16))&0xFF), (((uint32_t)((0 *1000L)/16))>>8), 1, 4,
  10,  (((uint32_t)(122))&0xFF), (((uint32_t)(122))>>8)+1 + 1140 - 1141+1 + 1142 - 1143+1 + 1144 - 1145+1 + 1146 - 1147+1 + 1148 - 1149,           (0)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,10,0,0,          (((uint32_t)(1200))&0xFF), (((uint32_t)(1200))>>8),(((uint32_t)(11))&0xFF), (((uint32_t)(11))>>8), 64,4,65  ,63,128,0,63,128,63,128,63,
  183, 120, 150, 60, 65, 10, 20, 80, 50, 5,
  138,     (((uint32_t)(123))&0xFF), (((uint32_t)(123))>>8)+1 + 1150 - 1151+1 + 1152 - 1153,((13) < 64*4 ? (13) : (256<<6)),2,     2,0,      0,      2, 64, 65,
  138,     (((uint32_t)(124))&0xFF), (((uint32_t)(124))>>8)+1 + 1154 - 1155+1 + 1156 - 1157,((13) < 64*4 ? (13) : (256<<6)),2,     2,0,      0,      2, 64, 65,
  138,     (((uint32_t)(125))&0xFF), (((uint32_t)(125))>>8)+1 + 1158 - 1159+1 + 1160 - 1161,((13) < 64*4 ? (13) : (256<<6)),2,     2,0,      0,      2, 64, 65,
  183, 25, 25, 80, 100, 120, 145, 64, 50, 5,
  74,  (((uint32_t)(126))&0xFF), (((uint32_t)(126))>>8)+1 + 1162 - 1163+1 + 1164 - 1165+1 + 1166 - 1167+1 + 1168 - 1169+1 + 1170 - 1171+1 + 1172 - 1173+1 + 1174 - 1175,           (4)&0xFF,((17) < 64*4 ? (17) : (256<<6)),255,  16,0,60,0,0,          (((uint32_t)(32))&0xFF), (((uint32_t)(32))>>8),(((uint32_t)(40))&0xFF), (((uint32_t)(40))>>8), 52,3,192,13,112,7,64,28,208,13,1,52,192,28,3,112,64,52,7,208,1,112,13,192,3,208,28,64,7,192,52,1,13,64,112,3,28,1,208,7,

  11,  (((uint32_t)(131))&0xFF), (((uint32_t)(131))>>8)+1 + 1176 - 1177+1 + 1178 - 1179+1 + 1180 - 1181+1 + 1182 - 1183+1 + 1184 - 1185,           ((((((2 + (1<<2)))>>2)&0x03) + ((1-1)<<2) + (((2<=2?(8-((((2 + (1<<2)))&0x03))*2):(((((2 + (1<<2)))&0x03))==2?0:4))&0x07)<<5)))&0xFF,((17) < 64*4 ? (17) : (256<<6)),255,  (((2 + (1<<2)))&0x03),0,20,0,0x40,          (((uint32_t)(400/16))&0xFF), (((uint32_t)(400/16))>>8),(((uint32_t)(300/16))&0xFF), (((uint32_t)(300/16))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),            ((((((2 + (1<<2)))&0x03))==1?0b00000001: (((((2 + (1<<2)))&0x03))==2?0b00000011:0b00000111))),
  1, (((uint32_t)(132))&0xFF), (((uint32_t)(132))>>8)+0,(2 + (0<<2)),((17) < 64*4 ? (17) : (256<<6)),0, 5,
  1, (((uint32_t)(132))&0xFF), (((uint32_t)(132))>>8)+0,(1 + (2<<2)),((17) < 64*4 ? (17) : (256<<6)),0, 8,
  1, (((uint32_t)(133))&0xFF), (((uint32_t)(133))>>8)+0,(1 + (0<<2)),((17) < 64*4 ? (17) : (256<<6)),0, 8,
  11,  (((uint32_t)(133))&0xFF), (((uint32_t)(133))>>8)+1 + 1186 - 1187+1 + 1188 - 1189+1 + 1190 - 1191+1 + 1192 - 1193+1 + 1194 - 1195,           ((((((2 + (1<<2)))>>2)&0x03) + ((1-1)<<2) + (((2<=2?(8-((((2 + (1<<2)))&0x03))*2):(((((2 + (1<<2)))&0x03))==2?0:4))&0x07)<<5)))&0xFF,((17) < 64*4 ? (17) : (256<<6)),255,  (((2 + (1<<2)))&0x03),0,18,0,0x40,          (((uint32_t)(400/16))&0xFF), (((uint32_t)(400/16))>>8),(((uint32_t)(300/16))&0xFF), (((uint32_t)(300/16))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),            ((((((2 + (1<<2)))&0x03))==1?0b00000001: (((((2 + (1<<2)))&0x03))==2?0b00000011:0b00000111))),
  82,  (((uint32_t)(134))&0xFF), (((uint32_t)(134))>>8)+1 + 1196 - 1197+1 + 1198 - 1199+1 + 1200 - 1201+1 + 1202 - 1203+1 + 1204 - 1205+1 + 1206 - 1207+1 + 1208 - 1209,           (168)&0xFF,((17) < 64*4 ? (17) : (256<<6)),255,  9,0,200,0,0,          (((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(40))&0xFF), (((uint32_t)(40))>>8),(((uint32_t)(20))&0xFF), (((uint32_t)(20))>>8),(((uint32_t)(100))&0xFF), (((uint32_t)(100))>>8),(((uint32_t)(320))&0xFF), (((uint32_t)(320))>>8),(((uint32_t)(180))&0xFF), (((uint32_t)(180))>>8),(((uint32_t)(330))&0xFF), (((uint32_t)(330))>>8),(((uint32_t)(180))&0xFF), (((uint32_t)(180))>>8),(((uint32_t)(460))&0xFF), (((uint32_t)(460))>>8),(((uint32_t)(31))&0xFF), (((uint32_t)(31))>>8), 63,0,0,248,1,0,0,0,0,0,0,0,0,0,0,0,0,64,146,36,1,146,36,9,0,0,0,0,0,0,0,
  11,  (((uint32_t)(137))&0xFF), (((uint32_t)(137))>>8)+1 + 1210 - 1211+1 + 1212 - 1213+1 + 1214 - 1215+1 + 1216 - 1217+1 + 1218 - 1219,           ((((((1 + (0<<2)))>>2)&0x03) + ((1-1)<<2) + (((2<=2?(8-((((1 + (0<<2)))&0x03))*2):(((((1 + (0<<2)))&0x03))==2?0:4))&0x07)<<5)))&0xFF,((17) < 64*4 ? (17) : (256<<6)),255,  (((1 + (0<<2)))&0x03),0,20,0,0x40,          (((uint32_t)(450/16))&0xFF), (((uint32_t)(450/16))>>8),(((uint32_t)(350/16))&0xFF), (((uint32_t)(350/16))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),            ((((((1 + (0<<2)))&0x03))==1?0b00000001: (((((1 + (0<<2)))&0x03))==2?0b00000011:0b00000111))),
  11,  (((uint32_t)(137))&0xFF), (((uint32_t)(137))>>8)+1 + 1220 - 1221+1 + 1222 - 1223+1 + 1224 - 1225+1 + 1226 - 1227+1 + 1228 - 1229,           ((((((1 + (1<<2)))>>2)&0x03) + ((1-1)<<2) + (((2<=2?(8-((((1 + (1<<2)))&0x03))*2):(((((1 + (1<<2)))&0x03))==2?0:4))&0x07)<<5)))&0xFF,((17) < 64*4 ? (17) : (256<<6)),255,  (((1 + (1<<2)))&0x03),0,80,0,0x40,          (((uint32_t)(450/16))&0xFF), (((uint32_t)(450/16))>>8),(((uint32_t)(350/16))&0xFF), (((uint32_t)(350/16))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),            ((((((1 + (1<<2)))&0x03))==1?0b00000001: (((((1 + (1<<2)))&0x03))==2?0b00000011:0b00000111))),
  1, (((uint32_t)(137))&0xFF), (((uint32_t)(137))>>8)+0,(1 + (2<<2)),((17) < 64*4 ? (17) : (256<<6)),0, 20,
  1, (((uint32_t)(138))&0xFF), (((uint32_t)(138))>>8)+0,(2 + (0<<2)),((17) < 64*4 ? (17) : (256<<6)),0, 6,
  1, (((uint32_t)(138))&0xFF), (((uint32_t)(138))>>8)+0,(1 + (2<<2)),((17) < 64*4 ? (17) : (256<<6)),0, 12,
  11,  (((uint32_t)(139))&0xFF), (((uint32_t)(139))>>8)+1 + 1230 - 1231+1 + 1232 - 1233+1 + 1234 - 1235+1 + 1236 - 1237+1 + 1238 - 1239,           ((((((1 + (0<<2)))>>2)&0x03) + ((1-1)<<2) + (((2<=2?(8-((((1 + (0<<2)))&0x03))*2):(((((1 + (0<<2)))&0x03))==2?0:4))&0x07)<<5)))&0xFF,((17) < 64*4 ? (17) : (256<<6)),255,  (((1 + (0<<2)))&0x03),0,60,0,0x40,          (((uint32_t)(450/16))&0xFF), (((uint32_t)(450/16))>>8),(((uint32_t)(350/16))&0xFF), (((uint32_t)(350/16))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8),            ((((((1 + (0<<2)))&0x03))==1?0b00000001: (((((1 + (0<<2)))&0x03))==2?0b00000011:0b00000111))),

  138,     (((uint32_t)(139))&0xFF), (((uint32_t)(139))>>8)+1 + 1240 - 1241+1 + 1242 - 1243,((17) < 64*4 ? (17) : (256<<6)),127,        255,     2,  5,  2, 29, 30,

  170+1 + 1244 - 1245+1 + 1246 - 1247+1 + 1248 - 1249, 74,  (((uint32_t)(142))&0xFF), (((uint32_t)(142))>>8)+1 + 1250 - 1251+1 + 1252 - 1253+1 + 1254 - 1255+1 + 1256 - 1257+1 + 1258 - 1259+1 + 1260 - 1261+1 + 1262 - 1263,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(142))&0xFF), (((uint32_t)(142))>>8)+1 + 1264 - 1265+1 + 1266 - 1267+1 + 1268 - 1269+1 + 1270 - 1271+1 + 1272 - 1273+1 + 1274 - 1275+1 + 1276 - 1277,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  1, (((uint32_t)(143))&0xFF), (((uint32_t)(143))>>8)+0,(2 + (0<<2)),((16) < 64*4 ? (16) : (256<<6)),0, 255,

  1, (((uint32_t)(143))&0xFF), (((uint32_t)(143))>>8)+0,(3 + (0<<2)),((7) < 64*4 ? (7) : (256<<6)),0, 255,
  1, (((uint32_t)(144))&0xFF), (((uint32_t)(144))>>8)+0,(1 + (0<<2)),((7) < 64*4 ? (7) : (256<<6)),0, 255,
  1, (((uint32_t)(144))&0xFF), (((uint32_t)(144))>>8)+0,(2 + (1<<2)),((16) < 64*4 ? (16) : (256<<6)),0, 255,

  1, (((uint32_t)(144))&0xFF), (((uint32_t)(144))>>8)+0,(2 + (1<<2)),((7) < 64*4 ? (7) : (256<<6)),0, 255,

  1, (((uint32_t)(144))&0xFF), (((uint32_t)(144))>>8)+0,(2 + (1<<2)),((5) < 64*4 ? (5) : (256<<6)),0, 255,

  1, (((uint32_t)(144))&0xFF), (((uint32_t)(144))>>8)+0,(2 + (1<<2)),((6) < 64*4 ? (6) : (256<<6)),0, 255,
  1, (((uint32_t)(145))&0xFF), (((uint32_t)(145))>>8)+0,(1 + (0<<2)),((18) < 64*4 ? (18) : (256<<6)),0, 255,
  1, (((uint32_t)(145))&0xFF), (((uint32_t)(145))>>8)+0,(1 + (1<<2)),((19) < 64*4 ? (19) : (256<<6)),0, 255,
  138,     (((uint32_t)(146))&0xFF), (((uint32_t)(146))>>8)+1 + 1278 - 1279+1 + 1280 - 1281,((0) < 64*4 ? (0) : (256<<6)),3,     5,5,      15,      8, 58, 59, 60, 58, 59, 60, 58, 59,

  138,     (((uint32_t)(148))&0xFF), (((uint32_t)(148))>>8)+1 + 1282 - 1283+1 + 1284 - 1285,((0) < 64*4 ? (0) : (256<<6)),7,     7,0,      1,      7, 60, 58, 41, 42, 40, 41, 42,
  138,     (((uint32_t)(151))&0xFF), (((uint32_t)(151))>>8)+1 + 1286 - 1287+1 + 1288 - 1289,((0) < 64*4 ? (0) : (256<<6)),6,     6,0,      1,      6, 44, 45, 46, 44, 45, 46,
  144,   (((uint32_t)((0b00000100|0b00010000)))&0xFF), (((uint32_t)((0b00000100|0b00010000)))>>8), 20+1 + 1290 - 1291+1 + 1292 - 1293+1 + 1294 - 1295, 254, (((uint32_t)((18 *1000L)/16))&0xFF), (((uint32_t)((18 *1000L)/16))>>8), 1, 71,

  174,  71, (1-1),
  11,  (((uint32_t)(153))&0xFF), (((uint32_t)(153))>>8)+1 + 1296 - 1297+1 + 1298 - 1299+1 + 1300 - 1301+1 + 1302 - 1303+1 + 1304 - 1305,           (112)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  3,0,255,0,0,          (((uint32_t)(2100))&0xFF), (((uint32_t)(2100))>>8),(((uint32_t)(100))&0xFF), (((uint32_t)(100))>>8),(((uint32_t)(55))&0xFF), (((uint32_t)(55))>>8), 0,4,0,8,0,4,0,242,62,1,128,0,64,0,32,0,16,0,8,0,4,0,2,0,1,128,60,64,30,32,0,16,0,8,0,4  ,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,

  138,     (((uint32_t)(162))&0xFF), (((uint32_t)(162))>>8)+1 + 1306 - 1307+1 + 1308 - 1309,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  2, 36, 38,
  170+1 + 1310 - 1311+1 + 1312 - 1313+1 + 1314 - 1315, 74,  (((uint32_t)(163))&0xFF), (((uint32_t)(163))>>8)+1 + 1316 - 1317+1 + 1318 - 1319+1 + 1320 - 1321+1 + 1322 - 1323+1 + 1324 - 1325+1 + 1326 - 1327+1 + 1328 - 1329,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,170,170,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(163))&0xFF), (((uint32_t)(163))>>8)+1 + 1330 - 1331+1 + 1332 - 1333+1 + 1334 - 1335+1 + 1336 - 1337+1 + 1338 - 1339+1 + 1340 - 1341+1 + 1342 - 1343,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,60,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  1, (((uint32_t)(164))&0xFF), (((uint32_t)(164))>>8)+0,(1 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 255,

  138,     (((uint32_t)(164))&0xFF), (((uint32_t)(164))>>8)+1 + 1344 - 1345+1 + 1346 - 1347,((0) < 64*4 ? (0) : (256<<6)),2,     2,0,      0,      2, 56, 57,
  138,     (((uint32_t)(165))&0xFF), (((uint32_t)(165))>>8)+1 + 1348 - 1349+1 + 1350 - 1351,((0) < 64*4 ? (0) : (256<<6)),1,     3,10,      20,      6, 55, 56, 57, 55, 56, 57,
  1, (((uint32_t)(167))&0xFF), (((uint32_t)(167))>>8)+0,(1 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 255,
  138,     (((uint32_t)(168))&0xFF), (((uint32_t)(168))>>8)+1 + 1352 - 1353+1 + 1354 - 1355,((0) < 64*4 ? (0) : (256<<6)),0,     3,10,      15,      3, 36, 45, 46,
  138,     (((uint32_t)(169))&0xFF), (((uint32_t)(169))>>8)+1 + 1356 - 1357+1 + 1358 - 1359,((0) < 64*4 ? (0) : (256<<6)),0,     2,20,      60,      4, 19, 23, 19, 23,
  138,     (((uint32_t)(173))&0xFF), (((uint32_t)(173))>>8)+1 + 1360 - 1361+1 + 1362 - 1363,((0) < 64*4 ? (0) : (256<<6)),3,     4,8,      30,      8, 19, 23, 58, 59, 60, 58, 59, 60,
  138,     (((uint32_t)(177))&0xFF), (((uint32_t)(177))>>8)+1 + 1364 - 1365+1 + 1366 - 1367,((0) < 64*4 ? (0) : (256<<6)),4,     4,5,      10,      4, 44, 45, 46, 44,

  138,     (((uint32_t)(178))&0xFF), (((uint32_t)(178))>>8)+1 + 1368 - 1369+1 + 1370 - 1371,((0) < 64*4 ? (0) : (256<<6)),4,     4,1,      3,      4, 56, 57, 55, 56,

  138,     (((uint32_t)(179))&0xFF), (((uint32_t)(179))>>8)+1 + 1372 - 1373+1 + 1374 - 1375,((0) < 64*4 ? (0) : (256<<6)),4,     4,0,      0,      4, 38, 36, 45, 46,
  138,     (((uint32_t)(181))&0xFF), (((uint32_t)(181))>>8)+1 + 1376 - 1377+1 + 1378 - 1379,((0) < 64*4 ? (0) : (256<<6)),18,     18,0,      0,      15, 44, 45, 46, 44, 45, 46, 44, 45, 46, 32, 45, 46, 44, 45, 46,
  138,     (((uint32_t)(186))&0xFF), (((uint32_t)(186))>>8)+1 + 1380 - 1381+1 + 1382 - 1383,((0) < 64*4 ? (0) : (256<<6)),3,     3,1,      1,      3, 55, 56, 57,
  138,     (((uint32_t)(187))&0xFF), (((uint32_t)(187))>>8)+1 + 1384 - 1385+1 + 1386 - 1387,((0) < 64*4 ? (0) : (256<<6)),1,     2,15,      45,      4, 19, 23, 19, 23,
  138,     (((uint32_t)(191))&0xFF), (((uint32_t)(191))>>8)+1 + 1388 - 1389+1 + 1390 - 1391,((0) < 64*4 ? (0) : (256<<6)),1,     3,15,      45,      8, 19, 23, 19, 23, 23, 58, 59, 57,
  138,     (((uint32_t)(197))&0xFF), (((uint32_t)(197))>>8)+1 + 1392 - 1393+1 + 1394 - 1395,((0) < 64*4 ? (0) : (256<<6)),2,     4,16,      44,      8, 19, 23, 58, 59, 60, 58, 59, 42,
  138,     (((uint32_t)(201))&0xFF), (((uint32_t)(201))>>8)+1 + 1396 - 1397+1 + 1398 - 1399,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  2, 40, 33,
  138,     (((uint32_t)(202))&0xFF), (((uint32_t)(202))>>8)+1 + 1400 - 1401+1 + 1402 - 1403,((0) < 64*4 ? (0) : (256<<6)),2,     4,15,      45,      9, 23, 19, 58, 59, 60, 58, 59, 60, 44,

  138,     (((uint32_t)(206))&0xFF), (((uint32_t)(206))>>8)+1 + 1404 - 1405+1 + 1406 - 1407,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  2, 45, 30,
  138,     (((uint32_t)(207))&0xFF), (((uint32_t)(207))>>8)+1 + 1410 - 1411+1 + 1412 - 1413,((0) < 64*4 ? (0) : (256<<6)),3,     5,15,      45,      13, (17 +1 + 1408 - 1409), 19, 23, 58, 37, 60, 58, 59, 60, 58, 59, 60, 58,

  138,     (((uint32_t)(213))&0xFF), (((uint32_t)(213))>>8)+1 + 1414 - 1415+1 + 1416 - 1417,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  1, 29,
  138,     (((uint32_t)(214))&0xFF), (((uint32_t)(214))>>8)+1 + 1418 - 1419+1 + 1420 - 1421,((0) < 64*4 ? (0) : (256<<6)),127,        255,     2,  5,  2, 40, 56,


  174,  0, (1-1),
  29, (((uint32_t)(222))&0xFF), (((uint32_t)(222))>>8)+1 + 1422 - 1423+1 + 1424 - 1425+1 + 1426 - 1427+1 + 1428 - 1429+1 + 1430 - 1431,           (16)&0xFF,((254) < 64*4 ? (254) : (256<<6)),255,  8,0,255,0,0,          (((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(5000))&0xFF), (((uint32_t)(5000))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(1000))&0xFF), (((uint32_t)(1000))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(12000))&0xFF), (((uint32_t)(12000))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(500))&0xFF), (((uint32_t)(500))>>8),(((uint32_t)(4500))&0xFF), (((uint32_t)(4500))>>8),(((uint32_t)(120))&0xFF), (((uint32_t)(120))>>8), 0,0,0,0,0,6,0,3,128,16,198,0,3,128,16,198,0,3,128,16,198,0,3,64,8,0,16,3,64,8,0,16,3,66,8,0,16,3,64,8,0,16,3,66,8,0,16,3,64,8,192,0,3,66,8,192,0,3,128,8,192,0,3,130,8,192,0,3,128,16,6,0,3,130,16,6,0,3,128,16,6,0,3,130,16,6,0,3,128,16,6,0,32,130,16,6,0,32,128,16  ,63,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  1, (((uint32_t)(224))&0xFF), (((uint32_t)(224))>>8)+0,(1 + (2<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 7,
  143,   1,       (((uint32_t)(225))&0xFF), (((uint32_t)(225))>>8), 0, (((uint32_t)(221))&0xFF), (((uint32_t)(221))>>8),
  143,   1,       (((uint32_t)(226))&0xFF), (((uint32_t)(226))>>8), 0, (((uint32_t)(222))&0xFF), (((uint32_t)(222))>>8),
  1, (((uint32_t)(227))&0xFF), (((uint32_t)(227))>>8)+0,(1 + (0<<2)),((0) < 64*4 ? (0) : (256<<6)),0, 127,

  170+1 + 1432 - 1433+1 + 1434 - 1435+1 + 1436 - 1437, 74,  (((uint32_t)(236))&0xFF), (((uint32_t)(236))>>8)+1 + 1438 - 1439+1 + 1440 - 1441+1 + 1442 - 1443+1 + 1444 - 1445+1 + 1446 - 1447+1 + 1448 - 1449+1 + 1450 - 1451,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(236))&0xFF), (((uint32_t)(236))>>8)+1 + 1452 - 1453+1 + 1454 - 1455+1 + 1456 - 1457+1 + 1458 - 1459+1 + 1460 - 1461+1 + 1462 - 1463+1 + 1464 - 1465,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1466 - 1467+1 + 1468 - 1469+1 + 1470 - 1471, 74,  (((uint32_t)(237))&0xFF), (((uint32_t)(237))>>8)+1 + 1472 - 1473+1 + 1474 - 1475+1 + 1476 - 1477+1 + 1478 - 1479+1 + 1480 - 1481+1 + 1482 - 1483+1 + 1484 - 1485,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(237))&0xFF), (((uint32_t)(237))>>8)+1 + 1486 - 1487+1 + 1488 - 1489+1 + 1490 - 1491+1 + 1492 - 1493+1 + 1494 - 1495+1 + 1496 - 1497+1 + 1498 - 1499,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1500 - 1501+1 + 1502 - 1503+1 + 1504 - 1505, 74,  (((uint32_t)(238))&0xFF), (((uint32_t)(238))>>8)+1 + 1506 - 1507+1 + 1508 - 1509+1 + 1510 - 1511+1 + 1512 - 1513+1 + 1514 - 1515+1 + 1516 - 1517+1 + 1518 - 1519,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(238))&0xFF), (((uint32_t)(238))>>8)+1 + 1520 - 1521+1 + 1522 - 1523+1 + 1524 - 1525+1 + 1526 - 1527+1 + 1528 - 1529+1 + 1530 - 1531+1 + 1532 - 1533,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1534 - 1535+1 + 1536 - 1537+1 + 1538 - 1539, 74,  (((uint32_t)(239))&0xFF), (((uint32_t)(239))>>8)+1 + 1540 - 1541+1 + 1542 - 1543+1 + 1544 - 1545+1 + 1546 - 1547+1 + 1548 - 1549+1 + 1550 - 1551+1 + 1552 - 1553,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(239))&0xFF), (((uint32_t)(239))>>8)+1 + 1554 - 1555+1 + 1556 - 1557+1 + 1558 - 1559+1 + 1560 - 1561+1 + 1562 - 1563+1 + 1564 - 1565+1 + 1566 - 1567,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1568 - 1569+1 + 1570 - 1571+1 + 1572 - 1573, 74,  (((uint32_t)(240))&0xFF), (((uint32_t)(240))>>8)+1 + 1574 - 1575+1 + 1576 - 1577+1 + 1578 - 1579+1 + 1580 - 1581+1 + 1582 - 1583+1 + 1584 - 1585+1 + 1586 - 1587,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(240))&0xFF), (((uint32_t)(240))>>8)+1 + 1588 - 1589+1 + 1590 - 1591+1 + 1592 - 1593+1 + 1594 - 1595+1 + 1596 - 1597+1 + 1598 - 1599+1 + 1600 - 1601,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1602 - 1603+1 + 1604 - 1605+1 + 1606 - 1607, 74,  (((uint32_t)(241))&0xFF), (((uint32_t)(241))>>8)+1 + 1608 - 1609+1 + 1610 - 1611+1 + 1612 - 1613+1 + 1614 - 1615+1 + 1616 - 1617+1 + 1618 - 1619+1 + 1620 - 1621,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(241))&0xFF), (((uint32_t)(241))>>8)+1 + 1622 - 1623+1 + 1624 - 1625+1 + 1626 - 1627+1 + 1628 - 1629+1 + 1630 - 1631+1 + 1632 - 1633+1 + 1634 - 1635,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1636 - 1637+1 + 1638 - 1639+1 + 1640 - 1641, 74,  (((uint32_t)(242))&0xFF), (((uint32_t)(242))>>8)+1 + 1642 - 1643+1 + 1644 - 1645+1 + 1646 - 1647+1 + 1648 - 1649+1 + 1650 - 1651+1 + 1652 - 1653+1 + 1654 - 1655,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(242))&0xFF), (((uint32_t)(242))>>8)+1 + 1656 - 1657+1 + 1658 - 1659+1 + 1660 - 1661+1 + 1662 - 1663+1 + 1664 - 1665+1 + 1666 - 1667+1 + 1668 - 1669,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1670 - 1671+1 + 1672 - 1673+1 + 1674 - 1675, 74,  (((uint32_t)(243))&0xFF), (((uint32_t)(243))>>8)+1 + 1676 - 1677+1 + 1678 - 1679+1 + 1680 - 1681+1 + 1682 - 1683+1 + 1684 - 1685+1 + 1686 - 1687+1 + 1688 - 1689,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(243))&0xFF), (((uint32_t)(243))>>8)+1 + 1690 - 1691+1 + 1692 - 1693+1 + 1694 - 1695+1 + 1696 - 1697+1 + 1698 - 1699+1 + 1700 - 1701+1 + 1702 - 1703,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1704 - 1705+1 + 1706 - 1707+1 + 1708 - 1709, 74,  (((uint32_t)(244))&0xFF), (((uint32_t)(244))>>8)+1 + 1710 - 1711+1 + 1712 - 1713+1 + 1714 - 1715+1 + 1716 - 1717+1 + 1718 - 1719+1 + 1720 - 1721+1 + 1722 - 1723,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(244))&0xFF), (((uint32_t)(244))>>8)+1 + 1724 - 1725+1 + 1726 - 1727+1 + 1728 - 1729+1 + 1730 - 1731+1 + 1732 - 1733+1 + 1734 - 1735+1 + 1736 - 1737,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1738 - 1739+1 + 1740 - 1741+1 + 1742 - 1743, 74,  (((uint32_t)(245))&0xFF), (((uint32_t)(245))>>8)+1 + 1744 - 1745+1 + 1746 - 1747+1 + 1748 - 1749+1 + 1750 - 1751+1 + 1752 - 1753+1 + 1754 - 1755+1 + 1756 - 1757,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(245))&0xFF), (((uint32_t)(245))>>8)+1 + 1758 - 1759+1 + 1760 - 1761+1 + 1762 - 1763+1 + 1764 - 1765+1 + 1766 - 1767+1 + 1768 - 1769+1 + 1770 - 1771,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1772 - 1773+1 + 1774 - 1775+1 + 1776 - 1777, 74,  (((uint32_t)(246))&0xFF), (((uint32_t)(246))>>8)+1 + 1778 - 1779+1 + 1780 - 1781+1 + 1782 - 1783+1 + 1784 - 1785+1 + 1786 - 1787+1 + 1788 - 1789+1 + 1790 - 1791,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(246))&0xFF), (((uint32_t)(246))>>8)+1 + 1792 - 1793+1 + 1794 - 1795+1 + 1796 - 1797+1 + 1798 - 1799+1 + 1800 - 1801+1 + 1802 - 1803+1 + 1804 - 1805,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,
  170+1 + 1806 - 1807+1 + 1808 - 1809+1 + 1810 - 1811, 74,  (((uint32_t)(247))&0xFF), (((uint32_t)(247))>>8)+1 + 1812 - 1813+1 + 1814 - 1815+1 + 1816 - 1817+1 + 1818 - 1819+1 + 1820 - 1821+1 + 1822 - 1823+1 + 1824 - 1825,           (224)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,0,0,0,6,          (((uint32_t)(0))&0xFF), (((uint32_t)(0))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1, 74,  (((uint32_t)(247))&0xFF), (((uint32_t)(247))>>8)+1 + 1826 - 1827+1 + 1828 - 1829+1 + 1830 - 1831+1 + 1832 - 1833+1 + 1834 - 1835+1 + 1836 - 1837+1 + 1838 - 1839,           (194)&0xFF,((255) < 64*4 ? (255) : (256<<6)),255,  1,80,255,0,6|0x20,          (((uint32_t)(700))&0xFF), (((uint32_t)(700))>>8),(((uint32_t)(1))&0xFF), (((uint32_t)(1))>>8), 1,

  0
  };
#line 569 "D:\data\doc\GitHub\pyMobaLedLib\python\LEDs_AutoProg\LEDs_AutoProg.h"
void Set_Start_Values(MobaLedLib_C &MobaLedLib)

{
}



typedef bool(*HandleValue_t) (uint8_t CallbackType, uint8_t ValueId, uint8_t* Value, uint16_t EEPromAddr, uint8_t TargetValueId, uint8_t Options);
#line 585 "D:\data\doc\GitHub\pyMobaLedLib\python\LEDs_AutoProg\LEDs_AutoProg.h"
typedef struct
    {
    uint8_t TypAndInCnt;
    uint8_t Channel;
    } __attribute__ ((packed)) Store_Channel_T;


const PROGMEM Store_Channel_T Store_Values[] =
         {
           { (uint8_t)0x00 + 1 , 0  },
           { (uint8_t)0x00 + 1 , 1  },
           { (uint8_t)0x00 + 1 , 2  },
           { (uint8_t)0x00 + 1 , 3  },
           { (uint8_t)0x00 + 1 , 4  },
           { (uint8_t)0x00 + 1 , 5  },
           { (uint8_t)0x00 + 1 , 6  },
           { (uint8_t)0x00 + 1 , 7  },
           { (uint8_t)0x00 + 1 , 8  },
           { (uint8_t)0x40  + 4 , 9    },
           { (uint8_t)0x00 + 1 , 14   },
           { (uint8_t)0x00 + 1 , 15  },
           { (uint8_t)0x00 + 1 , 16  },
           { (uint8_t)0x00 + 1 , 17   },
           { (uint8_t)0x00 + 1 , 18  },
           { (uint8_t)0x00 + 1 , 19  },
         };
