// This file contains the DCC and LED definitions.
//
// It was automatically generated by the program ProgGenerator Ver. 3.3.2G      by Hardi
// File creation: 05/17/25 14:19:30
// (Attention: The display in the Arduino IDE is not updated if Options/External Editor is disabled)

#ifndef __LEDS_AUTOPROG_H__
#define __LEDS_AUTOPROG_H__

#ifndef CONFIG_ONLY
#ifndef ARDUINO_RASPBERRY_PI_PICO
#ifndef FASTLED_ESP32_I2S
#define FASTLED_INTERNAL       // Disable version number message in FastLED library (looks like an error)
#endif
#include <FastLED.h>           // The FastLED library must be installed in addition if you got the error message "..fatal error: FastLED.h: No such file or directory"
                               // Arduino IDE: Sketch / Include library / Manage libraries                    Deutsche IDE: Sketch / Bibliothek einbinden / Bibliothek verwalten
                               //              Type "FastLED" in the "Filter your search..." field                          "FastLED" in das "Grenzen Sie ihre Suche ein" Feld eingeben
                               //              Select the entry and click "Install"                                         Gefundenen Eintrag auswaehlen und "Install" anklicken
#else
#include <PicoFastLED.h>       // Juergens minimum version or FastLED for Raspberry Pico
#endif
#endif // CONFIG_ONLY

#include <MobaLedLib.h>

#define START_MSG "LEDs_AutoProg Ver 3: ESP32 3.3.2G 05.17.25 14:19"

#define TWO_BUTTONS_PER_ADDRESS 1      // Two buttons (Red/Green) are used (DCC/LNet/CAN)
#ifdef NUM_LEDS
  #warning "'NUM_LEDS' definition in the main program is replaced by the included 'LEDs_AutoProg.h' with 248"
  #undef NUM_LEDS
#endif

#define NUM_LEDS 248                   // Number of LEDs (Maximal 256 RGB LEDs could be used)

#define LEDS_PER_CHANNEL ",247,1"

#define USE_PROTOCOL_DCC

#define RECEIVE_LED_COLOR_PER_RS232

#define GEN_BUTTON_RELEASE
#define GEN_BUTTON_RELEASE_COM GEN_OFF
#define USE_EXT_ADDR
#define USE_RS232_OR_SPI_AS_INPUT      // Use the RS232 or SPI Input to read DCC/SX commands from the second Arduino and from the PC (The SPI is only used if enabled with USE_SPI_COM)
#define ADDR_OFFSET 0

#define ADDR_MSK  0x3FFF  // 14 Bits are used for the Address

#define S_ONOFF   (uint16_t)0
#define B_RED     (uint16_t)(1<<14)
#define B_GREEN   (uint16_t)(2<<14)
#define O_RET_MSG (uint16_t)(3<<14)    // Return messages (Rueckmelder)
#define B_TAST    B_RED


typedef struct
    {
    uint16_t AddrAndTyp; // Addr range: 0..16383. The upper two bytes are used for the type
    uint8_t  InCnt;
    } __attribute__ ((packed)) Ext_Addr_T;

// Definition of external adresses
#ifdef CONFIG_ONLY
const Ext_Addr_T Ext_Addr[] __attribute__ ((section (".MLLAddressConfig"))) =
#else
const PROGMEM Ext_Addr_T Ext_Addr[] =
#endif
         { // Addr & Typ    InCnt
           { 100  + S_ONOFF,   1 },      // RGB Lichtwechsel Durchfahrten (3x WS2812) > 2x kopiert
           { 981  + S_ONOFF,   1 },      // Relais 1x UM (frei)
           { 982  + S_ONOFF,   1 },      // Relais 1x UM (frei)
           { 983  + S_ONOFF,   1 },      // Relais 1x UM (frei)
           { 984  + S_ONOFF,   1 },      // Relais 1x UM (frei)
           { 977  + S_ONOFF,   1 },      // ZIMO MXDECUP
           { 978  + S_ONOFF,   1 },      // Programmer Reserve
           { 976  + S_ONOFF,   1 },      // Steckdose
           { 103  + S_ONOFF,   1 },      // Relais 2
           { 101  + B_RED,     4 },      // Wei, Regenbogen und Farbwechsel > 9x kopiert (N_Buttons)
           { 27   + S_ONOFF,   1 },      // Kontrollleuchte PC (pc)
           { 28   + S_ONOFF,   1 },      // Blaulicht (pc)
           { 805  + S_ONOFF,   1 },      // Motor Hubwagen
           { 975  + S_ONOFF,   1 },      // Licht rot in Molkerei/Spritzerei bei Z21 Prog
           { 30   + S_ONOFF,   1 },      // Rundumlicht links, Sprinter & Vario 4 Stck (8x 0402 gelb)
           { 979  + S_ONOFF,   1 },      // Schattenbahnhof Beleuchtung
           { 980  + S_ONOFF,   1 },      // Freies Relais (rechts)
           { 201  + S_ONOFF,   1 },      // Excel row 350
         };


// Input channel defines for local inputs and expert users
#define INCH_DCC_100_ONOFF      0      // RGB Lichtwechsel Durchfahrten (3x WS2812) > 2x kopiert
#define INCH_DCC_981_ONOFF      1      // Relais 1x UM (frei)
#define INCH_DCC_982_ONOFF      2      // Relais 1x UM (frei)
#define INCH_DCC_983_ONOFF      3      // Relais 1x UM (frei)
#define INCH_DCC_984_ONOFF      4      // Relais 1x UM (frei)
#define INCH_DCC_977_ONOFF      5      // ZIMO MXDECUP
#define INCH_DCC_978_ONOFF      6      // Programmer Reserve
#define INCH_DCC_976_ONOFF      7      // Steckdose
#define INCH_DCC_103_ONOFF      8      // Relais 2
#define INCH_DCC_101_RED        9      // Wei, Regenbogen und Farbwechsel > 9x kopiert (N_Buttons)
#define INCH_DCC_101_GREEN      10     //     "
#define INCH_DCC_102_RED        11     //     "
#define INCH_DCC_102_GREEN      12     //     "
#define INCH_DCC_27_ONOFF       13     // Kontrollleuchte PC (pc)
#define INCH_DCC_28_ONOFF       14     // Blaulicht (pc)
#define INCH_DCC_805_ONOFF      15     // Motor Hubwagen
#define INCH_DCC_975_ONOFF      16     // Licht rot in Molkerei/Spritzerei bei Z21 Prog
#define INCH_DCC_30_ONOFF       17     // Rundumlicht links, Sprinter & Vario 4 Stck (8x 0402 gelb)
#define INCH_DCC_979_ONOFF      18     // Schattenbahnhof Beleuchtung
#define INCH_DCC_980_ONOFF      19     // Freies Relais (rechts)
#define INCH_DCC_201_ONOFF      20     // Excel row 350

// Local InCh variables
#define LOC_INCH0               21
#define LOC_INCH1               22
#define LOC_INCH2               23
#define LOC_INCH3               24
#define LOC_INCH4               25
#define LOC_INCH5               26
#define LOC_INCH6               27
#define LOC_INCH7               28
#define LOC_INCH8               29
#define LOC_INCH9               30
#define LOC_INCH10              31
#define LOC_INCH11              32
#define LOC_INCH12              33
#define LOC_INCH13              34
#define LOC_INCH14              35
#define LOC_INCH15              36
#define LOC_INCH16              37
#define LOC_INCH17              38
#define LOC_INCH18              39
#define LOC_INCH19              40
#define LOC_INCH20              41
#define LOC_INCH21              42
#define LOC_INCH22              43
#define LOC_INCH23              44
#define LOC_INCH24              45
#define LOC_INCH25              46
#define LOC_INCH26              47
#define LOC_INCH27              48
#define LOC_INCH28              49
#define LOC_INCH29              50
#define LOC_INCH30              51
#define LOC_INCH31              52
#define LOC_INCH32              53
#define LOC_INCH33              54
#define LOC_INCH34              55
#define LOC_INCH35              56
#define LOC_INCH36              57
#define LOC_INCH37              58


//*** Direct connected switches ***

#define START_SWITCHES_D  59                                       // Define the start number for the first mainboard switch
#define SwitchD1                59                                       // Z21-RM-Rckmelder: Adresse:1 Eingang:1
#define SwitchD2                60                                       // Z21-RM-Rckmelder: Adresse:1 Eingang:2
#define SwitchD3                61                                       // Z21-RM-Rckmelder: Adresse:1 Eingang:3

//*** Output Channels ***
#define START_VARIABLES   62                                       // Define the start number for the variables.
#define D1                      62                                       // Z21-RM-Rckmelder: Adresse:1 Eingang:4
#define D2                      63                                       // Z21-RM-Rckmelder: Adresse:1 Eingang:5
#define D3                      64                                       // Z21-RM-Rckmelder: Adresse:1 Eingang:6
#define Licht_Main              65                                       // Z21-RM-Rckmelder: Adresse:1 Eingang:7
#define Licht_Z21               66                                       // Z21-RM-Rckmelder: Adresse:1 Eingang:8
#define Licht_ESU               67                                       // Z21-RM-Rckmelder: Adresse:2 Eingang:1
#define Licht_Zimo              68                                       // Z21-RM-Rckmelder: Adresse:2 Eingang:2
#define Licht_Res               69                                       // Z21-RM-Rckmelder: Adresse:2 Eingang:3
#define Licht_OutN              70                                       // Z21-RM-Rckmelder: Adresse:2 Eingang:4
#define Licht_OutG              71                                       // Z21-RM-Rckmelder: Adresse:2 Eingang:5
#define Licht_OutB              72                                       // Z21-RM-Rckmelder: Adresse:2 Eingang:6
#define Licht_OutY              73                                       // Z21-RM-Rckmelder: Adresse:2 Eingang:7
#define Licht_OutW              74                                       // Z21-RM-Rckmelder: Adresse:2 Eingang:8
#define Licht_OutR              75                                       // Z21-RM-Rckmelder: Adresse:3 Eingang:1
#define Stapler                 76                                       // Z21-RM-Rckmelder: Adresse:3 Eingang:2

const PROGMEM uint8_t SwitchD_Pins[] = { 12,26,25 };               // Array of pins which read switches 'D'
#define SWITCH_D_INP_CNT sizeof(SwitchD_Pins)


#define START_SEND_INPUTS 59                                       // Start address of all switches/variables
#define TOTAL_SEND_INPUTS 18                                       // Number of used switches/variables
#define TOTAL_SWITCHES_A  0                                        // Number of used inputs for analog keyboard
#define TOTAL_SWITCHES_B  0                                        // Number of used inputs for keyboard 1
#define TOTAL_SWITCHES_C  0                                        // Number of used inputs for keyboard 2
#define TOTAL_SWITCHES_D  3                                        // Number of used inputs for main board switches
#define TOTAL_VARIABLES   15                                       // Number of used variables
/*********************/
#define SETUP_FASTLED()                                                      \
/*********************/                                                      \
  CLEDController& controller0 = FastLED.addLeds<NEOPIXEL, 27>(leds+  0,247); \
  CLEDController& controller1 = FastLED.addLeds<NEOPIXEL, 32>(leds+247,  1); \
                                                                             \
  controller0.clearLeds(256);                                                \
  controller1.clearLeds(256);                                                \
  FastLED.setDither(DISABLE_DITHER);       // avoid sending slightly modified brightness values
/*End*/

#define USE_ADDITIONAL_SETUP_PROC                                  // Activate the usage of the Additional_Setup_Proc()

//--------------------------
void Additional_Setup_Proc()
//--------------------------
{

  for (uint8_t i = 0; i < SWITCH_D_INP_CNT; i++)
    pinMode(pgm_read_byte_near(&SwitchD_Pins[i]), INPUT_PULLUP);
}

/****************************/
#define Additional_Loop_Proc() \
/****************************/ \
{                              \
  for (uint8_t i = 0; i < 3; i++) \
      MobaLedLib.Set_Input(SwitchD1 + i, !digitalRead(pgm_read_byte_near(&SwitchD_Pins[i])));\
}


//*******************************************************************
// *** Configuration array which defines the behavior of the LEDs ***
MobaLedLib_Configuration()
  {
  #define SEND_INPUTS                                                                                         /* Excel row 6                                                                                                                                                                                 */
  #ifdef ESP32                                                                                                /* Excel row 7                                                                                                                                                                                 */
     #define USE_ESP32_EXTENSIONS                                                                             /*     "                                                                                                                                                                                       */
     #define USE_UI                                                                                           /*     "                                                                                                                                                                                       */
     #define DISPLAY_FASTLED_FAULTS                                                                           /*     "                                                                                                                                                                                       */
  #endif                                                                                                      /*     "                                                                                                                                                                                       */
  T_FlipFlopReset(D1, SwitchD1, SI_0)                                                                         /* Schalter D1                                                                                                                                                                                 */
  T_FlipFlopReset(D2, SwitchD2, SI_0)                                                                         /* Schalter D2                                                                                                                                                                                 */
  T_FlipFlopReset(D3, SwitchD3, SI_0)                                                                         /* Schalter D3                                                                                                                                                                                 */
  RGB_Heartbeat_Color(0, 60, 120, 150, 1 Sek)                                                                 /* Kanal 0 Heartbeat ausgehend                                                                                                                                                                 */
  RGB_Heartbeat_Color(247, 60, 120, 150, 1 Sek)                                                               /* Kanal 1 Heartbeat ausgehend (deaktivieren bei PushButtons)                                                                                                                                  */
  Set_TV_COL1(SI_1, 31, 156, 40, 65, 0, 85, 70, 210, 60, 150)                                                 /* Excel row 29                                                                                                                                                                                */
  Set_TV_COL2(SI_1, 31, 156, 40, 65, 0, 85, 70, 210, 60, 150)                                                 /* Excel row 30                                                                                                                                                                                */
  RGB_Heartbeat_Color(1, 60, 255, 170, 700)                                                                   /* Verstrker-LED ankommend                                                                                                                                                                    */
  XPatternT1(2,28,0,3,0,255,0,PM_NORMAL,8 Sec,0,35,35,0,0,210,42,0,42,70,0,0,42,42,0,0,77,0)                  /* RGB Lichtwechsel Durchfahrten (3x WS2812) > 2x kopiert                                                                                                                                      */
  CopyLED(3, SI_1, 2)                                                                                         /* Kopie von RGB Lichtwechsel                                                                                                                                                                  */
  CopyLED(4, SI_1, 2)                                                                                         /* Kopie von RGB Lichtwechsel                                                                                                                                                                  */
  Const(5, C_ALL, INCH_DCC_100_ONOFF, 0, 40)                                                                  /* Stadtmauer (3x PLCC2ww)                                                                                                                                                                     */
  PatternT4(6,0,INCH_DCC_100_ONOFF,7,0,255,0,PM_NORMAL,19 Sek,2 Sek,5 Sek,4 Sek,0,32,48,24,8,2,133,2,33,144,72,32,2,145,8,36,16,10,129,2,193,32,48,16,8,0,0,0) /* Museum (7x PLCC2ww)                                                                                                                        */
  Const(8, C23, INCH_DCC_100_ONOFF, 0, 30)                                                                    /* Hauptturm (PLCC2ww), Trmchen 1+2 (2x 0603ww)                                                                                                                                               */
  Const(9, C_ALL, INCH_DCC_100_ONOFF, 0, 30)                                                                  /* Trmchen 3 + 4 (2x 0603ww), Uhr (PLCC2ww)                                                                                                                                                   */
  HouseT(10, INCH_DCC_100_ONOFF, 2, 2, 0, 0, NEON_LIGHT1M, NEON_LIGHT2M)                                      /* Friseur                                                                                                                                                                                     */
  // Next_LED(-1)                                                                                             /* Excel row 44                                                                                                                                                                                */
  HouseT(10, INCH_DCC_100_ONOFF, 2, 4, 15, 60, NEON_LIGHT3M, SINGLE_LED1, SINGLE_LED2D, SINGLE_LED3, ROOM_TV0) /* Hinter der Brauerei 7                                                                                                                                                                      */
  HouseT(13, INCH_DCC_100_ONOFF, 2, 3, 15, 45, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, ROOM_TV0, ROOM_TV1, ROOM_TV0, NEON_LIGHT1M) /* Hinter der Brauerei 6                                                                                                                                                */
  // Next_LED(-1)                                                                                             /* Excel row 47                                                                                                                                                                                */
  Const(17, C3, INCH_DCC_100_ONOFF, 0, 25)                                                                    /* Auenbeleuchtung Grn = Frei, Blau = Wandlampe                                                                                                                                              */
  HouseT(18, INCH_DCC_100_ONOFF, 2, 4, 15, 45, NEON_LIGHT1M, SINGLE_LED2D, SINGLE_LED3D, ROOM_TV0_CHIMNEY, ROOM_TV1) /* Hinter der Brauerei 5                                                                                                                                                                */
  HouseT(21, INCH_DCC_100_ONOFF, 2, 2, 0, 0, CANDLE1, CANDLE2)                                                /* Pizzeria (1 + 2)                                                                                                                                                                            */
  // Next_LED(-1)                                                                                             /* Excel row 51                                                                                                                                                                                */
  House(21, INCH_DCC_100_ONOFF, 1, 1, NEON_LIGHT3)                                                            /* Auenbeleuchtung Frei (3)                                                                                                                                                                   */
  HouseT(22, INCH_DCC_100_ONOFF, 5, 5, 0, 0, CANDLE1, CANDLE2, SINGLE_LED3D, SINGLE_LED1D, GAS_LIGHT2D)       /* Eisdiele (1 - 4), Auenleuchte (5), Frei (6)                                                                                                                                                */
  HouseT(24, INCH_DCC_100_ONOFF, 0, 2, 15, 45, SINGLE_LED1, SINGLE_LED2D, SINGLE_LED3, ROOM_TV0, ROOM_CHIMNEYD) /* Hinter der Brauerei 4                                                                                                                                                                     */
  HouseT(27, INCH_DCC_100_ONOFF, 1, 1, 0, 1, NEON_LIGHT1)                                                     /* Wanduhr                                                                                                                                                                                     */
  // Next_LED(-1)                                                                                             /* Excel row 58                                                                                                                                                                                */
  Const(27, C23, INCH_DCC_100_ONOFF, 0, 25)                                                                   /* Wandlampen Eingang                                                                                                                                                                          */
  Const(28, C12, INCH_DCC_100_ONOFF, 0, 25)                                                                   /* Wandlampen Eingang                                                                                                                                                                          */
  // Next_LED(-1)                                                                                             /* Excel row 61                                                                                                                                                                                */
  HouseT(28, INCH_DCC_100_ONOFF, 10, 10, 0, 0, NEON_LIGHT3M, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M) /* Leuchtreklame                                                                                                  */
  RGB_Heartbeat_Color(32, 60, 255, 170, 700)                                                                  /* Verstrker-LED ankommend                                                                                                                                                                    */
  RGB_Heartbeat_Color(33, 60, 255, 170, 700)                                                                  /* Verstrker-LED ankommend                                                                                                                                                                    */
  RGB_Heartbeat_Color(34, 60, 255, 170, 700)                                                                  /* Verstrker-LED ankommend                                                                                                                                                                    */
  Const(35, C_ALL, INCH_DCC_100_ONOFF, 0, 20)                                                                 /* Flutlichter rechts                                                                                                                                                                          */
  Const(36, C_ALL, INCH_DCC_100_ONOFF, 0, 20)                                                                 /* Flutlichter rechts                                                                                                                                                                          */
  Const(37, C_ALL, INCH_DCC_100_ONOFF, 0, 20)                                                                 /* Flutlichter links                                                                                                                                                                           */
  Const(38, C_ALL, INCH_DCC_100_ONOFF, 0, 20)                                                                 /* Flutlichter links                                                                                                                                                                           */
  // Reserve LEDs(1)                                                                                          /* Fotografen u. .                                                                                                                                                                            */
  Const(40, C_ALL, INCH_DCC_100_ONOFF, 0, 50)                                                                 /* Schiff links                                                                                                                                                                                */
  Const(41, C12, INCH_DCC_100_ONOFF, 0, 50)                                                                   /* Schiff links, rund                                                                                                                                                                          */
  Const(41, C3, INCH_DCC_100_ONOFF, 0, 20)                                                                    /* Schiff links                                                                                                                                                                                */
  Const(42, C_ALL, INCH_DCC_100_ONOFF, 0, 50)                                                                 /* Schiff hinten                                                                                                                                                                               */
  Const(43, C12, INCH_DCC_100_ONOFF, 0, 50)                                                                   /* Schiff rechts                                                                                                                                                                               */
  Const(43, C3, INCH_DCC_100_ONOFF, 0, 20)                                                                    /* Schiff rechts, rund                                                                                                                                                                         */
  Const(44, C_ALL, INCH_DCC_100_ONOFF, 0, 50)                                                                 /* Schiff rechts                                                                                                                                                                               */
  Const(45, C1, INCH_DCC_100_ONOFF, 0, 50)                                                                    /* Turm Front                                                                                                                                                                                  */
  Const(45, C23, INCH_DCC_100_ONOFF, 0, 20)                                                                   /* Turm Rund                                                                                                                                                                                   */
  Const(46, C12, SI_1, 0, 127)                                                                                /* Wandlampen Eingang                                                                                                                                                                          */
  GasLights(47, INCH_DCC_100_ONOFF, CANDLE, CANDLE)                                                           /* Wandlampen Eingang                                                                                                                                                                          */
  Const(49, C_ALL, INCH_DCC_100_ONOFF, 0, 32)                                                                 /* Turm                                                                                                                                                                                        */
  Const(50, C_ALL, INCH_DCC_100_ONOFF, 0, 32)                                                                 /* Turm                                                                                                                                                                                        */
  Const(51, C12, INCH_DCC_100_ONOFF, 0, 32)                                                                   /* Turm                                                                                                                                                                                        */
  Const(51, C3, INCH_DCC_100_ONOFF, 0, 25)                                                                    /* Spitze                                                                                                                                                                                      */
  Const(52, C_ALL, INCH_DCC_100_ONOFF, 0, 25)                                                                 /* Spitze                                                                                                                                                                                      */
  Const(53, C1, 1, 0, 255)                                                                                    /* Relais 1x UM (frei)                                                                                                                                                                         */
  Const(53, C2, 2, 0, 255)                                                                                    /* Relais 1x UM (frei)                                                                                                                                                                         */
  Const(53, C3, 3, 0, 255)                                                                                    /* Relais 1x UM (frei)                                                                                                                                                                         */
  Const(54, C1, 4, 0, 255)                                                                                    /* Relais 1x UM (frei)                                                                                                                                                                         */
  Const(54, C23, 5, 0, 255)                                                                                   /* ZIMO MXDECUP                                                                                                                                                                                */
  Const(55, C3, INCH_DCC_977_ONOFF, 0, 255)                                                                   /* Steckdose                                                                                                                                                                                   */
  // Next_LED(-2)                                                                                             /* Excel row 101                                                                                                                                                                               */
  Const(54, C23, 6, 0, 255)                                                                                   /* Programmer Reserve                                                                                                                                                                          */
  Const(55, C_ALL, INCH_DCC_978_ONOFF, 0, 255)                                                                /* Programmer Reserve                                                                                                                                                                          */
  // Next_LED(-1)                                                                                             /* Excel row 104                                                                                                                                                                               */
  Const(55, C3, 7, 0, 255)                                                                                    /* Steckdose                                                                                                                                                                                   */
  RGB_Heartbeat_Color(56, 60, 255, 170, 700)                                                                  /* Verstrker-LED ankommend                                                                                                                                                                    */
  RGB_Heartbeat_Color(57, 60, 255, 170, 700)                                                                  /* Verstrker-LED ankommend                                                                                                                                                                    */
  RGB_Heartbeat_Color(58, 60, 255, 170, 700)                                                                  /* Verstrker-LED ankommend                                                                                                                                                                    */
  RGB_Heartbeat_Color(59, 60, 255, 170, 700)                                                                  /* Verstrker-LED ankommend                                                                                                                                                                    */
  Const(60, C1, 8, 0, 255)                                                                                    /* Relais 2                                                                                                                                                                                    */
  Const(60, C3, INCH_DCC_103_ONOFF, 0, 255)                                                                   /* Relais 1 (Rauchgenerator)                                                                                                                                                                   */
  Set_CandleTab(0, 40, 40, 80, 90, 130, 150, 150, 0)                                                          /* Einstellungen fr Kerzen                                                                                                                                                                    */
  GasLights(61, INCH_DCC_103_ONOFF, CANDLE, CANDLE)                                                           /* Glut Grill + Feuerstelle                                                                                                                                                                    */
  GasLights(63, INCH_DCC_103_ONOFF, GAS_LIGHT1, GAS_LIGHT2, GAS_LIGHT3, NEON_LIGHT1, NEON_LIGHT2, NEON_LIGHT3) /* Beleuchtung Grillplatz                                                                                                                                                                     */
  Set_CandleTab(25, 25, 80, 100, 120, 145, 64, 50, 5)                                                         /* Standard-Einstellungen fr Kerze                                                                                                                                                            */
  HouseT(65, INCH_DCC_100_ONOFF, 4, 8, 5, 15, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, ROOM_DARK, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D) /* Gebude                        */
  HouseT(71, INCH_DCC_100_ONOFF, 6, 6, 0, 0, GAS_LIGHT1, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D) /* Laterne + 5x Flutlicht innen                                                                                                                                               */
  GasLights(73, INCH_DCC_100_ONOFF, CANDLE1, CANDLE2, CANDLE3)                                                /* Durchgang (Kerzen)                                                                                                                                                                          */
  GasLights(74, INCH_DCC_100_ONOFF, SINGLE_LED1, SINGLE_LED2, SINGLE_LED3)                                    /* 3x Flutlicht innen                                                                                                                                                                          */
  Set_CandleTab(35, 60, 80, 100, 120, 145, 64, 50, 5)                                                         /* Einstellungen fr Kerzen                                                                                                                                                                    */
  // Reserve LEDs(1)                                                                                          /* Kerzen im Turm nach hinten                                                                                                                                                                  */
  GasLights(76, INCH_DCC_100_ONOFF, CANDLE, CANDLE)                                                           /* Kerzen im Turm                                                                                                                                                                              */
  // Reserve LEDs(1)                                                                                          /* Kerzen im Turm nach hinten                                                                                                                                                                  */
  Set_CandleTab(25, 25, 80, 100, 120, 145, 64, 50, 5)                                                         /* Standard-Einstellungen fr Kerze                                                                                                                                                            */
  HouseT(79, INCH_DCC_100_ONOFF, 2, 2, 0, 0, CANDLE, CANDLE)                                                  /* Fackeln                                                                                                                                                                                     */
  // Activation: N_Buttons                                                                                    /* Wei, Regenbogen und Farbwechsel > 9x kopiert (N_Buttons)                                                                                                                                   */
  InCh_to_TmpVar(9, 4)                                                                                        /*     "                                                                                                                                                                                       */
  XPatternT1(81,28,SI_LocalVar,18,0,255,0,PM_NORMAL,3 Sek,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,13,5,15,13,5,15,13,5,15,13,5,15,13,5,15,13,5,0,0,150,30,0,60,50,0,0,30,30,0,0,55,0,0,25,50,30,0,60,50,0,0,30,30,0,0,55,0,0,25,50,0,0,150,50,0,0,30,30,0,0,55,0,0,25,50,0,0,150,30,0,60,30,30,0,0,55,0,0,25,50,0,0,150,30,0,60,50,0,0,0,55,0,0,25,50,0,0,150,30,0,60,50,0,0,30,30,0,0,25,50,0,0,150,30,0,60,50,0,0,30,30,0,0,55,0,0,0,150,0,0,150,0,0,150,0,0,150,0,0,150,0,0,150,30,0,60,30,0,60,30,0,60,30,0,60,30,0,60,30,0,60,55,0,0,55,0,0,55,0,0,55,0,0,55,0,0,55,0,0,30,30,0,30,30,0,30,30,0,30,30,0,30,30,0,30,30,0,0,55,0,0,55,0,0,55,0,0,55,0,0,55,0,0,55,0,0,25,50,0,25,50,0,25,50,0,25,50,0,25,50,0,25,50  ,63,191,192,0,0,0,0,1,192,0,0,0,0,2) /*     " */
  CopyLED(87, SI_1, 81)                                                                                       /* Kopie von Regenbogen                                                                                                                                                                        */
  CopyLED(88, SI_1, 81)                                                                                       /* Kopie von Regenbogen                                                                                                                                                                        */
  CopyLED(89, SI_1, 86)                                                                                       /* Kopie von Regenbogen plus 5                                                                                                                                                                 */
  CopyLED(90, SI_1, 85)                                                                                       /* Kopie von Regenbogen plus 4                                                                                                                                                                 */
  CopyLED(91, SI_1, 84)                                                                                       /* Kopie von Regenbogen plus 3                                                                                                                                                                 */
  CopyLED(92, SI_1, 83)                                                                                       /* Kopie von Regenbogen plus 2                                                                                                                                                                 */
  CopyLED(93, SI_1, 82)                                                                                       /* Kopie von Regenbogen plus 1                                                                                                                                                                 */
  CopyLED(94, SI_1, 81)                                                                                       /* Kopie von Regenbogen                                                                                                                                                                        */
  CopyLED(95, SI_1, 81)                                                                                       /* Kopie von Regenbogen                                                                                                                                                                        */
  RGB_Heartbeat_Color(96, 60, 255, 170, 700)                                                                  /* Verstrker-LED ankommend                                                                                                                                                                    */
  RGB_Heartbeat_Color(97, 60, 255, 170, 700)                                                                  /* Verstrker-LED ankommend                                                                                                                                                                    */
  GasLights(98, INCH_DCC_100_ONOFF, NEON_LIGHT1M, SINGLE_LED2D, SINGLE_LED3D)                                 /* Auenbeleuchtung Halle                                                                                                                                                                      */
  // Activation: RandomTime(40, 60)                                                                           /* Kontrollleuchte PC (pc)                                                                                                                                                                     */
  Random(LOC_INCH0, 13, RM_NORMAL, 40,  60, 1 ms, 1 ms)                                                       /*     "                                                                                                                                                                                       */
  New_Local_Var()                                                                                             /*     "                                                                                                                                                                                       */
  // Attention: State 0 is used if input is disabled                                                          /*     "                                                                                                                                                                                       */
  Counter(CF_ONLY_LOCALVAR | CF_RANDOM | CF_SKIP0, LOC_INCH0, 13, 0 Sec, 20)                                  /*     "                                                                                                                                                                                       */
  PatternT1(99,4,SI_LocalVar,3,0,150,0,0,60,64,85,85,85,85,21,17,85,102,86,221,93,85,17,81  ,63,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191,191) /*     "                                                                                                                        */
  APatternT1(100,4,14,4,0,60,0,PM_NORMAL,32,52,112,208,192,64,1,3,7,13,28)                                    /* Blaulicht (pc)                                                                                                                                                                              */
  // Next_LED(-1)                                                                                             /* Excel row 215                                                                                                                                                                               */
  Const(101, C2, 15, 0, 255)                                                                                  /* Motor Hubwagen                                                                                                                                                                              */
  Blink2(101, C3, INCH_DCC_805_ONOFF, 12 Sek, 1 Sek, 0, 255)                                                  /* Motor Hubwagen                                                                                                                                                                              */
  // Activation: Binary                                                                                       /* Schaltschrank (pc)                                                                                                                                                                          */
  Bin_InCh_to_TmpVar(INCH_DCC_27_ONOFF, 1)                                                                    /*     "                                                                                                                                                                                       */
  PatternT1(102,196,SI_LocalVar,3,0,40,0,0,15 Sec,2,192,3  ,0,63,191)                                         /*     "                                                                                                                                                                                       */
  // Set_ColTab(Red Green Blue)                                                                               /* Excel row 220                                                                                                                                                                               */
  Set_ColTab( 15,  13,   3, //  ROOM_COL0                                                                     /*     "                                                                                                                                                                                       */
              22,  44,  27, //  ROOM_COL1                                                                     /*     "                                                                                                                                                                                       */
             155,  73,   5, //  ROOM_COL2                                                                     /*     "                                                                                                                                                                                       */
              39,  18,   1, //  ROOM_COL3                                                                     /*     "                                                                                                                                                                                       */
              30,   0,   0, //  ROOM_COL4                                                                     /*     "                                                                                                                                                                                       */
              79,  39,   7, //  ROOM_COL5                                                                     /*     "                                                                                                                                                                                       */
              50,  50,  50, //  GAS_LIGHT D                                                                   /*     "                                                                                                                                                                                       */
             255, 255, 255, //  GAS LIGHT                                                                     /*     "                                                                                                                                                                                       */
              20,  20,  27, //  NEON_LIGHT D                                                                  /*     "                                                                                                                                                                                       */
              75, 100,  99, // *NEON_LIGHT M                                                                  /*     "                                                                                                                                                                                       */
             245, 245, 255, //  NEON_LIGHT                                                                    /*     "                                                                                                                                                                                       */
              50,  50,  20, //  ROOM_TV0 A                                                                    /*     "                                                                                                                                                                                       */
              70,  70,  30, //  ROOM_TV0 B                                                                    /*     "                                                                                                                                                                                       */
              50,  50,   8, //  ROOM_TV1 A                                                                    /*     "                                                                                                                                                                                       */
              50,  50,   8, //  ROOM_TV1 B                                                                    /*     "                                                                                                                                                                                       */
             255, 255, 255, //  SINGLE_LED                                                                    /*     "                                                                                                                                                                                       */
              50,  50,  50) //  SINGLE_LED D                                                                  /*     "                                                                                                                                                                                       */
  Logic(Licht_Main, INCH_DCC_100_ONOFF)                                                                       /* Licht in Molkerei/Spritzerei ohne Programmierung                                                                                                                                            */
  Logic(Licht_Z21, 16)                                                                                        /* Licht rot in Molkerei/Spritzerei bei Z21 Prog                                                                                                                                               */
  Logic(Licht_ESU, INCH_DCC_976_ONOFF)                                                                        /* Licht blau in Molkerei/Spritzerei bei ESU Prog                                                                                                                                              */
  Logic(Licht_Zimo, INCH_DCC_977_ONOFF)                                                                       /* Licht gelb in Molkerei/Spritzerei bei Zimo Prog                                                                                                                                             */
  Logic(Licht_Res, INCH_DCC_978_ONOFF)                                                                        /* Licht wei in Molkerei/Spritzerei Reserve                                                                                                                                                   */
  Logic(Licht_OutN, Licht_Main AND NOT Licht_Z21 AND NOT Licht_ESU AND NOT Licht_Zimo AND NOT Licht_Res)      /* Licht Neonrhre                                                                                                                                                                             */
  Logic(Licht_OutG, Licht_Z21 AND NOT Licht_ESU AND NOT Licht_Zimo AND NOT Licht_Res)                         /* Licht Grn - Z21                                                                                                                                                                            */
  Logic(Licht_OutB, Licht_ESU AND NOT Licht_Z21 AND NOT Licht_Zimo AND NOT Licht_Res)                         /* Licht Blau - ESU                                                                                                                                                                            */
  Logic(Licht_OutY, Licht_Zimo AND NOT Licht_Z21 AND NOT Licht_ESU AND NOT Licht_Res)                         /* Licht Blau - Zimo                                                                                                                                                                           */
  Logic(Licht_OutW, Licht_Res AND NOT Licht_ESU AND NOT Licht_Zimo AND NOT Licht_Z21)                         /* Licht Wei - Reserve                                                                                                                                                                        */
  Logic(Licht_OutR, Licht_Z21 AND Licht_ESU OR Licht_Z21 AND Licht_Zimo OR Licht_Z21 AND Licht_Res OR Licht_ESU AND Licht_Zimo OR Licht_ESU AND Licht_Res OR Licht_Zimo AND Licht_Res) /* Licht Rot - Fehler                                                                                                 */
  HouseT(103, Licht_OutN, 6, 6, 0, 1, NEON_LIGHTM, NEON_LIGHTM, NEON_LIGHTM, NEON_LIGHTM, NEON_LIGHTM, NEON_LIGHTM) /* Licht Neonrhre                                                                                                                                                                       */
  // Next_LED(-6)                                                                                             /* LEDs doppelt zuweisen                                                                                                                                                                       */
  Flash(103, C2, Licht_OutG, LOC_INCH1, 500, 500)                                                             /* Licht Grn - Z21                                                                                                                                                                            */
  Flash(104, C2, Licht_OutG, LOC_INCH2, 500, 500)                                                             /* Excel row 236                                                                                                                                                                               */
  Flash(105, C2, Licht_OutG, LOC_INCH3, 500, 500)                                                             /* Excel row 237                                                                                                                                                                               */
  Flash(106, C2, Licht_OutG, LOC_INCH4, 500, 500)                                                             /* Excel row 238                                                                                                                                                                               */
  Flash(107, C2, Licht_OutG, LOC_INCH5, 500, 500)                                                             /* Excel row 239                                                                                                                                                                               */
  Flash(108, C2, Licht_OutG, LOC_INCH6, 500, 500)                                                             /* Excel row 240                                                                                                                                                                               */
  // Next_LED(-6)                                                                                             /* Excel row 242                                                                                                                                                                               */
  Flash(103, C23, Licht_OutB, LOC_INCH7, 500, 500)                                                            /* Licht Blau - ESU                                                                                                                                                                            */
  Flash(104, C23, Licht_OutB, LOC_INCH8, 500, 500)                                                            /* Excel row 244                                                                                                                                                                               */
  Flash(105, C23, Licht_OutB, LOC_INCH9, 500, 500)                                                            /* Excel row 245                                                                                                                                                                               */
  Flash(106, C23, Licht_OutB, LOC_INCH10, 500, 500)                                                           /* Excel row 246                                                                                                                                                                               */
  Flash(107, C23, Licht_OutB, LOC_INCH11, 500, 500)                                                           /* Excel row 247                                                                                                                                                                               */
  Flash(108, C23, Licht_OutB, LOC_INCH12, 500, 500)                                                           /* Excel row 248                                                                                                                                                                               */
  // Next_LED(-6)                                                                                             /* Excel row 250                                                                                                                                                                               */
  Flash(103, C12, Licht_OutY, LOC_INCH13, 500, 500)                                                           /* Licht Gelb - Zimo                                                                                                                                                                           */
  Flash(104, C12, Licht_OutY, LOC_INCH14, 500, 500)                                                           /* Excel row 252                                                                                                                                                                               */
  Flash(105, C12, Licht_OutY, LOC_INCH15, 500, 500)                                                           /* Excel row 253                                                                                                                                                                               */
  Flash(106, C12, Licht_OutY, LOC_INCH16, 500, 500)                                                           /* Excel row 254                                                                                                                                                                               */
  Flash(107, C12, Licht_OutY, LOC_INCH17, 500, 500)                                                           /* Excel row 255                                                                                                                                                                               */
  Flash(108, C12, Licht_OutY, LOC_INCH18, 500, 500)                                                           /* Excel row 256                                                                                                                                                                               */
  // Next_LED(-6)                                                                                             /* Excel row 258                                                                                                                                                                               */
  Flash(103, C_ALL, Licht_OutW, LOC_INCH19, 500, 500)                                                         /* Licht Wei - Reserve                                                                                                                                                                        */
  Flash(104, C_ALL, Licht_OutW, LOC_INCH20, 500, 500)                                                         /* Excel row 260                                                                                                                                                                               */
  Flash(105, C_ALL, Licht_OutW, LOC_INCH21, 500, 500)                                                         /* Excel row 261                                                                                                                                                                               */
  Flash(106, C_ALL, Licht_OutW, LOC_INCH22, 500, 500)                                                         /* Excel row 262                                                                                                                                                                               */
  Flash(107, C_ALL, Licht_OutW, LOC_INCH23, 500, 500)                                                         /* Excel row 263                                                                                                                                                                               */
  Flash(108, C_ALL, Licht_OutW, LOC_INCH24, 500, 500)                                                         /* Excel row 264                                                                                                                                                                               */
  // Next_LED(-6)                                                                                             /* Excel row 266                                                                                                                                                                               */
  Flash(103, C1, Licht_OutR, LOC_INCH25, 500, 500)                                                            /* Licht Rot - Fehler                                                                                                                                                                          */
  Flash(104, C1, Licht_OutR, LOC_INCH26, 500, 500)                                                            /* Excel row 268                                                                                                                                                                               */
  Flash(105, C1, Licht_OutR, LOC_INCH27, 500, 500)                                                            /* Excel row 269                                                                                                                                                                               */
  Flash(106, C1, Licht_OutR, LOC_INCH28, 500, 500)                                                            /* Excel row 270                                                                                                                                                                               */
  Flash(107, C1, Licht_OutR, LOC_INCH29, 500, 500)                                                            /* Excel row 271                                                                                                                                                                               */
  Flash(108, C1, Licht_OutR, LOC_INCH30, 500, 500)                                                            /* Excel row 272                                                                                                                                                                               */
  // Activation: RandomTime(12 Sek, 30 Sek)                                                                   /* Signalsule 1                                                                                                                                                                               */
  Random(LOC_INCH31, INCH_DCC_27_ONOFF, RM_NORMAL, 12 Sek,  30 Sek, 1 ms, 1 ms)                               /*     "                                                                                                                                                                                       */
  New_Local_Var()                                                                                             /*     "                                                                                                                                                                                       */
  // Attention: State 0 is used if input is disabled                                                          /*     "                                                                                                                                                                                       */
  Counter(CF_ONLY_LOCALVAR | CF_RANDOM | CF_SKIP0, LOC_INCH31, INCH_DCC_27_ONOFF, 0 Sec, 14)                  /*     "                                                                                                                                                                                       */
  PatternT14(109,68,SI_LocalVar,3,0,40,0,0,20,20,700,500,500,500,500,1,1,1,1,1,1,1,192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191) /*     "                                                                                                        */
  // Activation: RandomTime(12 Sek, 30 Sek)                                                                   /* Signalsule 2                                                                                                                                                                               */
  Random(LOC_INCH32, INCH_DCC_27_ONOFF, RM_NORMAL, 12 Sek,  30 Sek, 1 ms, 1 ms)                               /*     "                                                                                                                                                                                       */
  New_Local_Var()                                                                                             /*     "                                                                                                                                                                                       */
  // Attention: State 0 is used if input is disabled                                                          /*     "                                                                                                                                                                                       */
  Counter(CF_ONLY_LOCALVAR | CF_RANDOM | CF_SKIP0, LOC_INCH32, INCH_DCC_27_ONOFF, 0 Sec, 14)                  /*     "                                                                                                                                                                                       */
  PatternT14(110,68,SI_LocalVar,3,0,40,0,0,20,20,700,500,500,500,500,1,1,1,1,1,1,1,192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191) /*     "                                                                                                        */
  // Activation: RandomTime(12 Sek, 30 Sek)                                                                   /* Signalsule 3                                                                                                                                                                               */
  Random(LOC_INCH33, INCH_DCC_27_ONOFF, RM_NORMAL, 12 Sek,  30 Sek, 1 ms, 1 ms)                               /*     "                                                                                                                                                                                       */
  New_Local_Var()                                                                                             /*     "                                                                                                                                                                                       */
  // Attention: State 0 is used if input is disabled                                                          /*     "                                                                                                                                                                                       */
  Counter(CF_ONLY_LOCALVAR | CF_RANDOM | CF_SKIP0, LOC_INCH33, INCH_DCC_27_ONOFF, 0 Sec, 14)                  /*     "                                                                                                                                                                                       */
  PatternT14(111,68,SI_LocalVar,3,0,40,0,0,20,20,700,500,500,500,500,1,1,1,1,1,1,1,192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191) /*     "                                                                                                        */
  Blink2(112, C1, INCH_DCC_27_ONOFF, 0.7 Sek, 0.02 Sek, 0, 40)                                                /* Signalsule 4 - defekt                                                                                                                                                                      */
  // Activation: RandomTime(12 Sek, 30 Sek)                                                                   /* Signalsule 5                                                                                                                                                                               */
  Random(LOC_INCH34, INCH_DCC_27_ONOFF, RM_NORMAL, 12 Sek,  30 Sek, 1 ms, 1 ms)                               /*     "                                                                                                                                                                                       */
  New_Local_Var()                                                                                             /*     "                                                                                                                                                                                       */
  // Attention: State 0 is used if input is disabled                                                          /*     "                                                                                                                                                                                       */
  Counter(CF_ONLY_LOCALVAR | CF_RANDOM | CF_SKIP0, LOC_INCH34, INCH_DCC_27_ONOFF, 0 Sec, 14)                  /*     "                                                                                                                                                                                       */
  PatternT14(113,68,SI_LocalVar,3,0,40,0,0,20,20,700,500,500,500,500,1,1,1,1,1,1,1,192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191) /*     "                                                                                                        */
  // Activation: RandomTime(12 Sek, 30 Sek)                                                                   /* Signalsule 6                                                                                                                                                                               */
  Random(LOC_INCH35, INCH_DCC_27_ONOFF, RM_NORMAL, 12 Sek,  30 Sek, 1 ms, 1 ms)                               /*     "                                                                                                                                                                                       */
  New_Local_Var()                                                                                             /*     "                                                                                                                                                                                       */
  // Attention: State 0 is used if input is disabled                                                          /*     "                                                                                                                                                                                       */
  Counter(CF_ONLY_LOCALVAR | CF_RANDOM | CF_SKIP0, LOC_INCH35, INCH_DCC_27_ONOFF, 0 Sec, 14)                  /*     "                                                                                                                                                                                       */
  PatternT14(114,68,SI_LocalVar,3,0,40,0,0,20,20,700,500,500,500,500,1,1,1,1,1,1,1,192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191) /*     "                                                                                                        */
  // Activation: RandomTime(12 Sek, 30 Sek)                                                                   /* Signalsule 7                                                                                                                                                                               */
  Random(LOC_INCH36, INCH_DCC_27_ONOFF, RM_NORMAL, 12 Sek,  30 Sek, 1 ms, 1 ms)                               /*     "                                                                                                                                                                                       */
  New_Local_Var()                                                                                             /*     "                                                                                                                                                                                       */
  // Attention: State 0 is used if input is disabled                                                          /*     "                                                                                                                                                                                       */
  Counter(CF_ONLY_LOCALVAR | CF_RANDOM | CF_SKIP0, LOC_INCH36, INCH_DCC_27_ONOFF, 0 Sec, 14)                  /*     "                                                                                                                                                                                       */
  PatternT14(115,68,SI_LocalVar,3,0,40,0,0,20,20,700,500,500,500,500,1,1,1,1,1,1,1,192,0,44,192,2,48,12,195,48,12,163,170,42  ,63,192,1,192,2,192,3,191,191,191,191,191,191,191,191,191,191) /*     "                                                                                                        */
  Set_CandleTab(81, 100, 60, 160, 60, 72, 80, 50, 5)                                                          /* Excel row 282                                                                                                                                                                               */
  HouseT(116, INCH_DCC_27_ONOFF, 1, 1, 2, 5, CANDLE2)                                                         /* Schaltschrank                                                                                                                                                                               */
  HouseT(117, INCH_DCC_27_ONOFF, 1, 1, 2, 5, CANDLE2)                                                         /* Schaltschrank                                                                                                                                                                               */
  HouseT(118, INCH_DCC_27_ONOFF, 1, 1, 2, 5, CANDLE2)                                                         /* Schaltschrank                                                                                                                                                                               */
  PatternT2(119,64,INCH_DCC_27_ONOFF,3,0,80,0,0,800,200,10)                                                   /* Schaltschrank_defekt (pc)                                                                                                                                                                   */
  HouseT(120, INCH_DCC_27_ONOFF, 1, 1, 2, 5, CANDLE2)                                                         /* Schaltschrank                                                                                                                                                                               */
  // Activation: RandomTime(5 Sek, 8 Sek)                                                                     /* Waage (pc)                                                                                                                                                                                  */
  Random(LOC_INCH37, INCH_DCC_27_ONOFF, RM_NORMAL, 5 Sek,  8 Sek, 1 ms, 1 ms)                                 /*     "                                                                                                                                                                                       */
  New_Local_Var()                                                                                             /*     "                                                                                                                                                                                       */
  // Attention: State 0 is used if input is disabled                                                          /*     "                                                                                                                                                                                       */
  Counter(CF_ONLY_LOCALVAR | CF_RANDOM | CF_SKIP0, LOC_INCH37, INCH_DCC_27_ONOFF, 0 Sec, 4)                   /*     "                                                                                                                                                                                       */
  PatternT1(121,0,SI_LocalVar,3,0,10,0,0,1200,64,4,65  ,63,128,0,63,128,63,128,63)                            /*     "                                                                                                                                                                                       */
  Set_CandleTab(120, 150, 60, 65, 10, 20, 80, 50, 5)                                                          /* Excel row 290                                                                                                                                                                               */
  HouseT(122, INCH_DCC_27_ONOFF, 2, 2, 0, 0, CANDLE2, CANDLE3)                                                /* Schaltschrank                                                                                                                                                                               */
  HouseT(123, INCH_DCC_27_ONOFF, 2, 2, 0, 0, CANDLE2, CANDLE3)                                                /* Schaltschrank                                                                                                                                                                               */
  HouseT(124, INCH_DCC_27_ONOFF, 2, 2, 0, 0, CANDLE2, CANDLE3)                                                /* Schaltschrank                                                                                                                                                                               */
  Set_CandleTab(25, 25, 80, 100, 120, 145, 64, 50, 5)                                                         /* Excel row 294                                                                                                                                                                               */
  APatternT1(125,4,17,16,0,60,0,PM_NORMAL,32,52,3,192,13,112,7,64,28,208,13,1,52,192,28,3,112,64,52,7,208,1,112,13,192,3,208,28,64,7,192,52,1,13,64,112,3,28,1,208,7) /* Rundumlicht links, Sprinter & Vario 4 Stck (8x 0402 gelb)                                                                          */
  // Next_LED(-1)                                                                                             /* Excel row 305                                                                                                                                                                               */
  Blink2(130, C23, INCH_DCC_30_ONOFF, 300, 400, 0, 20)                                                        /* Blinker Sprinter, vorn                                                                                                                                                                      */
  Const(131, C12, INCH_DCC_30_ONOFF, 0, 5)                                                                    /* Standlicht Sprinter, vorn                                                                                                                                                                   */
  Const(131, C3, INCH_DCC_30_ONOFF, 0, 8)                                                                     /* Standlicht Sprinter, hinten links                                                                                                                                                           */
  Const(132, C1, INCH_DCC_30_ONOFF, 0, 8)                                                                     /* Standlicht Sprinter, hinten rechts                                                                                                                                                          */
  Blink2(132, C23, INCH_DCC_30_ONOFF, 300, 400, 0, 18)                                                        /* Blinker Sprinter, hinten                                                                                                                                                                    */
  APatternT9(133,168,INCH_DCC_30_ONOFF,9,0,200,0,PM_NORMAL,20,40,20,100,320,180,330,180,460,63,0,0,248,1,0,0,0,0,0,0,0,0,0,0,0,0,64,146,36,1,146,36,9,0,0,0,0,0,0,0) /* Sicherungsanhnger                                                                                                                   */
  Blink2(136, C1, INCH_DCC_30_ONOFF, 350, 450, 0, 20)                                                         /* Blinker Vario, vorn (in Reihe)                                                                                                                                                              */
  Blink2(136, C2, INCH_DCC_30_ONOFF, 350, 450, 0, 80)                                                         /* Blinker Vario, hinten (in Reihe)                                                                                                                                                            */
  Const(136, C3, INCH_DCC_30_ONOFF, 0, 20)                                                                    /* Standlicht Vario, hinten                                                                                                                                                                    */
  Const(137, C12, INCH_DCC_30_ONOFF, 0, 6)                                                                    /* Standlicht Vario vorn                                                                                                                                                                       */
  Const(137, C3, INCH_DCC_30_ONOFF, 0, 12)                                                                    /* Standlicht Sicherungsanhnger                                                                                                                                                               */
  Blink2(138, C1, INCH_DCC_30_ONOFF, 350, 450, 0, 60)                                                         /* Blinker Sicherungsanhnger                                                                                                                                                                  */
  // Next_LED(-1)                                                                                             /* Excel row 320                                                                                                                                                                               */
  GasLights(138, INCH_DCC_30_ONOFF, GAS_LIGHT2, GAS_LIGHT3)                                                   /* Baustellenbeleuchtung (2x)                                                                                                                                                                  */
  // Reserve LEDs(2)                                                                                          /* 2 Ausgnge an WS2811 frei                                                                                                                                                                   */
  RGB_Heartbeat_Color(141, 60, 255, 170, 700)                                                                 /* Verstrker-LED ankommend                                                                                                                                                                    */
  Const(142, C12, INCH_DCC_975_ONOFF, 0, 255)                                                                 /* Programmiergleis Z21                                                                                                                                                                        */
  // Next_LED(-1)                                                                                             /* Excel row 332                                                                                                                                                                               */
  Const(142, C_ALL, INCH_DCC_976_ONOFF, 0, 255)                                                               /* ESU Lokprogrammer                                                                                                                                                                           */
  Const(143, C1, INCH_DCC_976_ONOFF, 0, 255)                                                                  /* ESU Lokprogrammer                                                                                                                                                                           */
  Const(143, C23, INCH_DCC_975_ONOFF, 0, 255)                                                                 /* Sicherheitszone                                                                                                                                                                             */
  // Next_LED(-1)                                                                                             /* Excel row 336                                                                                                                                                                               */
  Const(143, C23, INCH_DCC_976_ONOFF, 0, 255)                                                                 /* Sicherheitszone                                                                                                                                                                             */
  // Next_LED(-1)                                                                                             /* Excel row 338                                                                                                                                                                               */
  Const(143, C23, INCH_DCC_977_ONOFF, 0, 255)                                                                 /* Sicherheitszone                                                                                                                                                                             */
  // Next_LED(-1)                                                                                             /* Excel row 340                                                                                                                                                                               */
  Const(143, C23, INCH_DCC_978_ONOFF, 0, 255)                                                                 /* Sicherheitszone                                                                                                                                                                             */
  Const(144, C1, 18, 0, 255)                                                                                  /* Schattenbahnhof Beleuchtung                                                                                                                                                                 */
  Const(144, C2, 19, 0, 255)                                                                                  /* Freies Relais (rechts)                                                                                                                                                                      */
  HouseT(145, INCH_DCC_100_ONOFF, 3, 5, 5, 15, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D) /* Verwaltung                                                                                                                                 */
  // Next_LED(-1)                                                                                             /* Excel row 347                                                                                                                                                                               */
  HouseT(147, INCH_DCC_100_ONOFF, 7, 7, 0, 1, SINGLE_LED3D, SINGLE_LED1D, NEON_LIGHT2D, NEON_LIGHT3D, NEON_LIGHT1D, NEON_LIGHT2D, NEON_LIGHT3D) /* Lagerhalle                                                                                                                                                */
  HouseT(150, INCH_DCC_100_ONOFF, 6, 6, 0, 1, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M) /* Rampe                                                                                                                                                                   */
  MonoFlop(Stapler, 20, 18 Sek)                                                                               /* Excel row 350                                                                                                                                                                               */
  // Activation: Binary                                                                                       /* Gabelstapler (pc)                                                                                                                                                                           */
  Bin_InCh_to_TmpVar(Stapler, 1)                                                                              /*     "                                                                                                                                                                                       */
  PatternT2(152,112,SI_LocalVar,3,0,255,0,0,2100,100,0,4,0,8,0,4,0,242,62,1,128,0,64,0,32,0,16,0,8,0,4,0,2,0,1,128,60,64,30,32,0,16,0,8,0,4  ,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63) /*     "                                                                                                            */
  // Reserve LEDs(8)                                                                                          /* Freier Single LED-Connector                                                                                                                                                                 */
  GasLights(161, INCH_DCC_100_ONOFF, NEON_LIGHT1, NEON_LIGHT3)                                                /* Licht                                                                                                                                                                                       */
  RGB_Heartbeat_Color(162, 60, 255, 170, 700)                                                                 /* Verstrker-LED ankommend                                                                                                                                                                    */
  Const(163, C1, INCH_DCC_100_ONOFF, 0, 255)                                                                  /* Telekom Magenta                                                                                                                                                                             */
  // Next_LED(-1)                                                                                             /* Excel row 361                                                                                                                                                                               */
  HouseT(163, INCH_DCC_100_ONOFF, 2, 2, 0, 0, SINGLE_LED2, SINGLE_LED3)                                       /* Telekom Laden + Leuchtreklame                                                                                                                                                               */
  HouseT(164, INCH_DCC_100_ONOFF, 1, 3, 10, 20, SINGLE_LED1, SINGLE_LED2, SINGLE_LED3, SINGLE_LED1, SINGLE_LED2, SINGLE_LED3) /* Wohnungen                                                                                                                                                                   */
  Const(166, C1, INCH_DCC_100_ONOFF, 0, 255)                                                                  /* Buchhandlung                                                                                                                                                                                */
  HouseT(167, INCH_DCC_100_ONOFF, 0, 3, 10, 15, NEON_LIGHT1, NEON_LIGHT2M, NEON_LIGHT3M)                      /* Treppenhaus                                                                                                                                                                                 */
  HouseT(168, INCH_DCC_100_ONOFF, 0, 2, 20, 60, ROOM_TV0, ROOM_TV1, ROOM_TV0, ROOM_TV1)                       /* Wohnungen                                                                                                                                                                                   */
  HouseT(172, INCH_DCC_100_ONOFF, 3, 4, 8, 30, ROOM_TV0, ROOM_TV1, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D) /* Wohnungen                                                                                                                                          */
  HouseT(176, INCH_DCC_100_ONOFF, 4, 4, 5, 10, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M, NEON_LIGHT1M)        /* Geschfte (Erdgeschoss)                                                                                                                                                                     */
  // Next_LED(-1)                                                                                             /* Excel row 370                                                                                                                                                                               */
  HouseT(177, INCH_DCC_100_ONOFF, 4, 4, 1, 3, SINGLE_LED2, SINGLE_LED3, SINGLE_LED1, SINGLE_LED2)             /* Bar (Erste Etage)                                                                                                                                                                           */
  // Next_LED(-1)                                                                                             /* Excel row 372                                                                                                                                                                               */
  HouseT(178, INCH_DCC_100_ONOFF, 4, 4, 0, 0, NEON_LIGHT3, NEON_LIGHT1, NEON_LIGHT2M, NEON_LIGHT3M)           /* Leuchtreklame                                                                                                                                                                               */
  HouseT(180, INCH_DCC_100_ONOFF, 18, 18, 0, 0, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M, GAS_LIGHT1D, NEON_LIGHT2M, NEON_LIGHT3M, NEON_LIGHT1M, NEON_LIGHT2M, NEON_LIGHT3M) /* Gasthof zm Stern - Auenbeleuchtung      */
  HouseT(185, INCH_DCC_100_ONOFF, 3, 3, 1, 1, SINGLE_LED1, SINGLE_LED2, SINGLE_LED3)                          /* Gasthof zm Stern - Restaurant                                                                                                                                                               */
  HouseT(186, INCH_DCC_100_ONOFF, 1, 2, 15, 45, ROOM_TV0, ROOM_TV1, ROOM_TV0, ROOM_TV1)                       /* Gasthof zm Stern - Zimmer Etage 2                                                                                                                                                           */
  HouseT(190, INCH_DCC_100_ONOFF, 1, 3, 15, 45, ROOM_TV0, ROOM_TV1, ROOM_TV0, ROOM_TV1, ROOM_TV1, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3) /* Gasthof zm Stern - Zimmer Etage 3                                                                                                                              */
  HouseT(196, INCH_DCC_100_ONOFF, 2, 4, 16, 44, ROOM_TV0, ROOM_TV1, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, NEON_LIGHT3D) /* Bahnhofsstrae 1                                                                                                                                  */
  GasLights(200, INCH_DCC_100_ONOFF, NEON_LIGHT1D, GAS_LIGHT2D)                                               /* Bahnhofsstrae - Laden + Auenbeleuchtung + frei                                                                                                                                            */
  HouseT(201, INCH_DCC_100_ONOFF, 2, 4, 15, 45, ROOM_TV1, ROOM_TV0, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, NEON_LIGHT1M) /* Bahnhofsstrae 2                                                                                                                    */
  // Next_LED(-1)                                                                                             /* Excel row 383                                                                                                                                                                               */
  GasLights(205, INCH_DCC_100_ONOFF, NEON_LIGHT2M, GAS_LIGHT3)                                                /* Bahnhofsstrae 2 - Laden + Auenbeleuchtung                                                                                                                                                 */
  HouseT(206, INCH_DCC_100_ONOFF, 3, 5, 15, 45, ROOM_CHIMNEYD, ROOM_TV0, ROOM_TV1, SINGLE_LED1D, NEON_LIGHT2, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D, SINGLE_LED2D, SINGLE_LED3D, SINGLE_LED1D) /* Bahnhofsstrae 3                                                            */
  // Next_LED(-1)                                                                                             /* Excel row 386                                                                                                                                                                               */
  GasLights(212, INCH_DCC_100_ONOFF, GAS_LIGHT2)                                                              /* Bahnhofsstrae 3 - Auenbeleuchtung + 1 freier Ausgang                                                                                                                                      */
  GasLights(213, INCH_DCC_100_ONOFF, NEON_LIGHT1D, SINGLE_LED2)                                               /* Excel row 390                                                                                                                                                                               */
  // Reserve LEDs(7)                                                                                          /* Single LED Connector berspringen                                                                                                                                                           */
  // Activation: Binary                                                                                       /* Ampel inkl. Rckleuchten > 2x kopiert                                                                                                                                                       */
  Bin_InCh_to_TmpVar(INCH_DCC_100_ONOFF, 1)                                                                   /*     "                                                                                                                                                                                       */
  PatternT20(221,16,SI_LocalVar,8,0,255,0,0,500,5000,500,1000,500,12000,500,500,500,500,500,500,500,500,500,500,500,500,500,4500,0,0,0,0,0,6,0,3,128,16,198,0,3,128,16,198,0,3,128,16,198,0,3,64,8,0,16,3,64,8,0,16,3,66,8,0,16,3,64,8,0,16,3,66,8,0,16,3,64,8,192,0,3,66,8,192,0,3,128,8,192,0,3,130,8,192,0,3,128,16,6,0,3,130,16,6,0,3,128,16,6,0,3,130,16,6,0,3,128,16,6,0,32,130,16,6,0,32,128,16  ,63,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1) /*     " */
  Const(223, C3, INCH_DCC_100_ONOFF, 0, 7)                                                                    /* Scheinwerfer Auto rechts                                                                                                                                                                    */
  CopyLED(224, INCH_DCC_100_ONOFF, 221)                                                                       /* Kopie von "Ampel inkl. Rckleuchten"                                                                                                                                                        */
  CopyLED(225, INCH_DCC_100_ONOFF, 222)                                                                       /* Kopie von "Ampel inkl. Rckleuchten" plus 1                                                                                                                                                 */
  Const(226, C1, INCH_DCC_100_ONOFF, 0, 127)                                                                  /* Scheinwerfer Auto links                                                                                                                                                                     */
  // Reserve LEDs(8)                                                                                          /* Single LED Connector berspringen                                                                                                                                                           */
  RGB_Heartbeat_Color(235, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 12                                                                                                                                                                    */
  RGB_Heartbeat_Color(236, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 11                                                                                                                                                                    */
  RGB_Heartbeat_Color(237, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 10                                                                                                                                                                    */
  RGB_Heartbeat_Color(238, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 09                                                                                                                                                                    */
  RGB_Heartbeat_Color(239, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 08                                                                                                                                                                    */
  RGB_Heartbeat_Color(240, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 07                                                                                                                                                                    */
  RGB_Heartbeat_Color(241, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 06                                                                                                                                                                    */
  RGB_Heartbeat_Color(242, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 05                                                                                                                                                                    */
  RGB_Heartbeat_Color(243, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 04                                                                                                                                                                    */
  RGB_Heartbeat_Color(244, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 03                                                                                                                                                                    */
  RGB_Heartbeat_Color(245, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 02                                                                                                                                                                    */
  RGB_Heartbeat_Color(246, 80, 255, 0, 700)                                                                   /* Verstrker-LED zurck 01                                                                                                                                                                    */

  EndCfg // End of the configuration
  };
//*******************************************************************

#ifndef COPYLED_OFF
#define COPYLED_OFF 0
#endif

#ifndef COPYLED_OFF_ONCE
#define COPYLED_OFF_ONCE 1
#endif

//---------------------------------------------
void Set_Start_Values(MobaLedLib_C &MobaLedLib)
//---------------------------------------------
{
}


// if function returns TRUE the calling loop stops
typedef bool(*HandleValue_t) (uint8_t CallbackType, uint8_t ValueId, uint8_t* Value, uint16_t EEPromAddr, uint8_t TargetValueId, uint8_t Options);


#define InCnt_MSK  0x003F  // 6 bits are used for the InCnt, 2 bits for the type ttcc cccc => Max InCnt=63
#define IS_COUNTER (uint8_t)0x80
#define IS_PULSE   (uint8_t)0x40
#define IS_TOGGLE  (uint8_t)0x00
#define COUNTER_ID

typedef struct
    {
    uint8_t TypAndInCnt; // Type bits 7 & 6, InCnt 0..5
    uint8_t Channel;
    } __attribute__ ((packed)) Store_Channel_T;

// Definition of channels and counters that need to store state in EEProm
const PROGMEM Store_Channel_T Store_Values[] =
         { // Mode + InCnt , Channel
           { IS_COUNTER    , COUNTER_ID 1        },      // Schalter D1
           { IS_COUNTER    , COUNTER_ID 2        },      // Schalter D2
           { IS_COUNTER    , COUNTER_ID 3        },      // Schalter D3
           { IS_TOGGLE + 1 , INCH_DCC_100_ONOFF  },      // RGB Lichtwechsel Durchfahrten (3x WS2812) > 2x kopiert
           { IS_TOGGLE + 1 , INCH_DCC_981_ONOFF  },      // Relais 1x UM (frei)
           { IS_TOGGLE + 1 , INCH_DCC_982_ONOFF  },      // Relais 1x UM (frei)
           { IS_TOGGLE + 1 , INCH_DCC_983_ONOFF  },      // Relais 1x UM (frei)
           { IS_TOGGLE + 1 , INCH_DCC_984_ONOFF  },      // Relais 1x UM (frei)
           { IS_TOGGLE + 1 , INCH_DCC_977_ONOFF  },      // ZIMO MXDECUP
           { IS_TOGGLE + 1 , INCH_DCC_978_ONOFF  },      // Programmer Reserve
           { IS_TOGGLE + 1 , INCH_DCC_976_ONOFF  },      // Steckdose
           { IS_TOGGLE + 1 , INCH_DCC_103_ONOFF  },      // Relais 2
           { IS_PULSE  + 4 , INCH_DCC_101_RED    },      // Wei, Regenbogen und Farbwechsel > 9x kopiert (N_Buttons)
           { IS_TOGGLE + 1 , INCH_DCC_28_ONOFF   },      // Blaulicht (pc)
           { IS_TOGGLE + 1 , INCH_DCC_805_ONOFF  },      // Motor Hubwagen
           { IS_TOGGLE + 1 , INCH_DCC_975_ONOFF  },      // Licht rot in Molkerei/Spritzerei bei Z21 Prog
           { IS_TOGGLE + 1 , INCH_DCC_30_ONOFF   },      // Rundumlicht links, Sprinter & Vario 4 Stck (8x 0402 gelb)
           { IS_TOGGLE + 1 , INCH_DCC_979_ONOFF  },      // Schattenbahnhof Beleuchtung
           { IS_TOGGLE + 1 , INCH_DCC_980_ONOFF  },      // Freies Relais (rechts)
         };

#ifndef CONFIG_ONLY
#endif // CONFIG_ONLY





#endif // __LEDS_AUTOPROG_H__
